
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
** @(#)vgtek.h	1.3	(NCSA)	8/7/87
*/

/* output devices */

#define MAXRG 4

#define DEVNULL 0
#define SUN 1
#define PS 2
#define HP 3

#define PREDCOUNT 100

extern int 
	RGSinit(), RGSpoint(), RGSdrawline(), RGSnewwin(),
	RGSclrscr(), RGSpagedone(), RGSdataline(), RGSpencolor(),
	RGScharmode(), RGSshowcur(), RGSlockcur(), RGShidecur(),
	RGSclose(), RGSuncover(), RGSinfo(),
	RGSgmode(), RGStmode(), RGSgin(), RGSbell(),

	RG0init(), RG0point(), RG0drawline(), RG0newwin(),
	RG0clrscr(), RG0pagedone(), RG0dataline(), RG0pencolor(),
	RG0charmode(), RG0showcur(), RG0lockcur(), RG0hidecur(),
	RG0close(), RG0uncover(), RG0info(),
	RG0gmode(), RG0tmode(), 

	RGPinit(), RGPpoint(), RGPdrawline(), RGPnewwin(),
	RGPclrscr(), RGPpagedone(), RGPdataline(), RGPpencolor(),
	RGPcharmode(), RGPshowcur(), RGPlockcur(), RGPhidecur(),
	RGPclose(), RGPuncover(), RGPinfo(),
	RGPgmode(), RGPtmode(),

	RGHPinit(), RGHPpoint(), RGHPdrawline(), RGHPnewwin(),
	RGHPclrscr(), RGHPpagedone(), RGHPdataline(), RGHPpencolor(),
	RGHPcharmode(), RGHPshowcur(), RGHPlockcur(), RGHPhidecur(),
	RGHPclose(), RGHPuncover(), RGHPinfo(),
	RGHPgmode(), RGHPtmode()
;

extern char
	*RGSdevname(), *RG0devname(), *RGPdevname(), *RGHPdevname();

static RGLINK RG[MAXRG] = {
	RG0init, RG0point, RG0drawline, RG0newwin,
	RG0clrscr, RG0pagedone, RG0dataline, RG0pencolor,
	RG0charmode, RG0showcur, RG0lockcur, RG0hidecur,
	RG0close, RG0uncover, RG0info,
	RG0gmode, RG0tmode, donothing, RG0devname,donothing, 

	RGSinit, RGSpoint, RGSdrawline, RGSnewwin,
	RGSclrscr, RGSpagedone, RGSdataline, RGSpencolor,
	RGScharmode, RGSshowcur, RGSlockcur, RGShidecur,
	RGSclose, RGSuncover, RGSinfo,
	RGSgmode, RGStmode, RGSgin, RGSdevname, RGSbell,

	RGPinit, RGPpoint, RGPdrawline, RGPnewwin,
	RGPclrscr, RGPpagedone, RGPdataline, RGPpencolor,
	RGPcharmode, RGPshowcur, RGPlockcur, RGPhidecur,
	RGPclose, RGPuncover, RGPinfo,
	RGPgmode, RGPtmode, donothing, RGPdevname,donothing, 

	RGHPinit, RGHPpoint, RGHPdrawline, RGHPnewwin,
	RGHPclrscr, RGHPpagedone, RGHPdataline, RGHPpencolor,
	RGHPcharmode, RGHPshowcur, RGHPlockcur, RGHPhidecur,
	RGHPclose, RGHPuncover, RGHPinfo,
	RGHPgmode, RGHPtmode, donothing, RGHPdevname,donothing, 
};
