
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)rgp.c	1.10	(NCSA)	8/12/87";
#endif lint

/*

rgp.c by Aaron Contorer for NCSA
Copyright 1987, board of trustees, University of Illinois

Routines for PostScript output.  Only 1 window output at a time.

*/

#define TRUE 1
#define FALSE 0
#define MAXVEC 100

static char *psname = "PostScript output";
static char busy; /* is device already in use */
static int winbot,winleft,wintall,winwide;
	/* position and size of window into virtual space */
static int (*outfunc)();
	/* the function to call with pointer to strings */
static char pstext[100];
	/* the string containing the PostScript output text */
static char PSblank, PSnopath;
static int veccount;
	/* number of vectors in the current path.
	Maintained due to PostScript's limited path complexity ability. */
static int cursx,cursy;
	/* Storing PS cursor location to avoid redundant movement of cursor
	to where it already is. */


static signore(s)
char *s;
/* Ignore the string pointer passed here. */
{}


RGPoutfunc(f)
int (*f)();
/*
	Specify the function that is to be called with pointers to all
	the PostScript strings.
*/
{
	outfunc = f;
}


static stroke()
{
	if (!PSnopath) (*outfunc)(" S ");
}

static PSenv()
/* set up PostScript environment for new page */
{
	/* Map 4k x 4k graphics onto 11x8 inch paper space,
	leaving margins and preserving 4x3 aspect ratio. */

	(*outfunc)("533 72 translate\n");
	(*outfunc)("90 rotate\n");
	(*outfunc)("newpath\n 1 setlinewidth\n 0.16 0.12 scale\n");
	cursx = cursy = -9999;
	veccount = 0;
}

static psbegin()
/* set up PS environment for whole new printout */
{
	(*outfunc)("%! PostScript code from NCSA software\n");
	(*outfunc)("% National Center for Supercomputing Applications\n");
	(*outfunc)("% at the University of Illinois\n\n");
	(*outfunc)("/M { moveto } def\n");
	(*outfunc)("/L { lineto } def\n");
	(*outfunc)("/N { newpath } def\n");
	(*outfunc)("/S { stroke } def\n");
	(*outfunc)("/R { rlineto } def\n");
	(*outfunc)("/H { 0 0 moveto newpath } def\n");
}

int RGPnewwin()
{
	if (busy) return(-1);
	else {
		busy=TRUE;
		psbegin();
		PSnopath=TRUE;
		pstext[0] = '\0';
		PSblank=TRUE;
		return(0);
	}
}

RGPclrscr(w){
	RGPpagedone(w);
}

RGPclose(w) {
	RGPclrscr(w);
	busy=FALSE;
}

RGPpoint(w,x,y) {
	(*outfunc)("3 0 R -3 0 R\n");
	PSblank=FALSE;
	PSnopath=FALSE;
	cursx=x;
	cursy=y;
} 

RGPdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
{
	if (PSblank) {
		PSenv();
		PSblank=FALSE;
	}
	veccount++;
	if (veccount==MAXVEC || x0 != cursx || y0 != cursy) {
		stroke();
		sprintf(pstext,"H %d %d M ",x0,y0);
		(*outfunc)(pstext);
	}
	sprintf(pstext,"%d %d L\n",x1,y1);
	(*outfunc)(pstext);
	PSnopath=FALSE;
	cursx=x1;
	cursy=y1;
}

RGPpagedone(w) {
	if (!PSblank) {
		stroke();
		(*outfunc)("showpage\n");
		(*outfunc)("% ++ DONE\n");
	}
	PSblank=TRUE;
}

RGPdataline(w,data,count) {}
RGPpencolor(w,color){}
RGPcharmode(w,rotation,size) {}
RGPshowcur() {}
RGPlockcur() {}
RGPhidecur() {}
RGPbell(w) {}
RGPuncover(w) {}

char *RGPdevname() {
	return(psname);
}

RGPinit() {
	busy=FALSE;
	PSblank=TRUE;
	PSnopath=TRUE;
	outfunc=signore;
}

RGPinfo(w,a,b,c,d,v) {}

RGPgmode() {}
RGPtmode() {}
