      SUBROUTINE WFINTR(NRPLWV,NBANDS,NKPTS,DATAKE,NBANOC,CPTWFP,
     &     NPLWKP,PLWVEN,NFIND,SCAL,CELEN, 
     &     NGX, NGY, NGZ, LPCTX, LPCTY, LPCTZ, NINDPW, RECC)
C=======================================================================
C
C """"""""""""""""""""""""" SUBROUTINE WFINIT """"""""""""""""""""""""""
C
C THIS SUBROUTINES INITIALISES THE WAVEFUNCTIONS FOR THE MOLECULAR
C DYNAMICS BY FILLING THE BANDS AT EACH K POINT WITH THE LOWEST ENERGY
C PLANE WAVE BASIS STATES. IF THE SYSTEM HAS HIGH SYMMETRY THIS METHOD
C MAY NOT BE APPROPRIATE BECAUSE THE LOWEST ENERGY PLANE WAVES MAY NOT
C SPAN THE LOWEST BANDS.
C
C=======================================================================
      IMPLICIT COMPLEX (C)
      DIMENSION DATAKE(*)
      DIMENSION CPTWFP(*)
      DIMENSION CELEN(*)
      DIMENSION LPCTX(*), LPCTY(*), LPCTZ(*), NINDPW(*), RECC(3,3)
C=======================================================================
C
C                       DIMENSION STATEMENTS
C
C PLWVEN = THE ENERGIES OF THE LOWEST KINETIC ENERGY PLANE WAVE BASIS
C          STATES
C NFIND = THE INDICES OF THE LOWEST ENERGY PLANE WAVE BASIS STATES
C=======================================================================
      DIMENSION PLWVEN(*)
      DIMENSION NFIND(*)
      DATA HSQDTM /3.810033/
C=======================================================================
C INITIALISE THE ENERGIES OF THE BASIS STATES TO A LARGE VALUE SO THAT
C LOWER ENERGY BASIS STATES WILL BE FOUND
C=======================================================================
      WRITE(*,*)' '
      WRITE(*,*)'WELCOME TO WFINIT'
      DO 2010 MM=1,NBANDS
      PLWVEN(MM)=1000.0
 2010 CONTINUE
C=======================================================================
C RUN THROUGH THE SET OF PLANE WAVE BASIS STATES AT THE PRESENT K POINT
C AND FIND THE NBANDS LOWEST ENERGY STATES
C=======================================================================
      DO 2100 NNN=1,NPLWKP
      NINDX=1+(7*(NNN-1))
C=======================================================================
C IF THE ENERGY OF THIS BASIS STATE IS HIGHER THAN THE NBANDS LOWEST
C ENERGIES FOUND SO FAR MOVE ONTO THE NEXT BASIS STATE
C=======================================================================
      IF(DATAKE(NINDX).GT.PLWVEN(NBANOC)) GO TO 2107
C=======================================================================
C     FOR SILICON ONLY (BUT OK FOR OTHERS)
C=======================================================================
      M=NINDPW(NNN)
C=======================================================================
C     FIRST IN UNITS OF RECIPROAL VECTORS (B1,B2,B3)
C=======================================================================
      IGX=LPCTX((M-1)     -((M-1)/   NGX   )*NGX+1)
      IGY=LPCTY((M-1)/NGX -((M-1)/(NGX*NGY))*NGY+1)
      IGZ=LPCTZ((M-1)/(NGX*NGY)                 +1)
C=======================================================================
C     NOW IN THE CARTESIAN COORDINATION (IN UNIT OF 2Pi/ANGSTROM)
C=======================================================================
      GX= IGX*RECC(1,1) + IGY*RECC(2,1) + IGZ*RECC(3,1)
      GY= IGX*RECC(1,2) + IGY*RECC(2,2) + IGZ*RECC(3,2)
      GZ= IGX*RECC(1,3) + IGY*RECC(2,3) + IGZ*RECC(3,3)
C=======================================================================
C     NOW IN UNITS OF SCAL=2*PI/A
C=======================================================================
      GX=GX/SCAL
      GY=GY/SCAL
      GZ=GZ/SCAL
      ITEST=0
C=======================================================================
C     MC PAYNE'S WAY
C=======================================================================
      IF(ITEST.EQ.0) THEN
        GX=GX+0.10
        GY=GY+0.11
        GZ=GZ+0.12
        IF(ABS(GX+GY).GT.2) GO TO 2107
        IF(ABS(GX+GZ).GT.2) GO TO 2107
        IF(ABS(GY+GZ).GT.2) GO TO 2107
        IF(ABS(GX-GY).GT.2) GO TO 2107
        IF(ABS(GX-GZ).GT.2) GO TO 2107
        IF(ABS(GY-GZ).GT.2) GO TO 2107
      ELSE
C=======================================================================
C     X WENG'S WAY
C
C     SKIP THE G=(200)-FAMILY (see p106,Ashcroft and Mermin)
C     for monoatomic diamond lattice,
C     S(K)=0 if Kx+Ky+kz = twice an odd number (.. -6,-2,2,6,10..) 
C=======================================================================
      GSUM=ABS(GX+GY+GZ)
      IF(ABS(GSUM-2.0).LE.3E-02) THEN
C      WRITE(*,1000) IGX,IGY,IGZ,GX,GY,GZ,DATAKE(NINDX)
1000  FORMAT(2X,'FOR Si, WE SKIPPED G=(',3I3,')*RECC = (',3F5.1,')',
     &       ' KE=',F10.5)
      GOTO 2107
      END IF
      END IF
C=======================================================================
C     FOR GRAPHITE ONLY
C=======================================================================
C      IF(IABS(IGZ).GT.2) GOTO 2107
C      IF(IGZ.LE.-1) GOTO 2107 
C      IF(IABS(IGX)+IABS(IGY)+IABS(IGZ).EQ.0) GOTO 2107
C=======================================================================
C IF NOT FIND THE NUMBER OF STATES IN THE PRESENT NBANDS LOWEST THAT
C HAVE HIGHER ENERGIES
C=======================================================================
      NSWAP=0
      DO 2110 M=1,NBANOC
      IF(DATAKE(NINDX).GT.PLWVEN(NBANOC+1-M)) GO TO 2200
      NSWAP=NSWAP+1
 2110 CONTINUE
 2200 CONTINUE
C=======================================================================
C PUT THIS BASIS STATE AT ITS RIGHTFUL PLACE AMONGST THE LOWEST ENERGY
C PLANE WAVE BASIS STATES AND MOVE ALL THE HIGHER ENERGY COMPONENTS UP
C ONE POSITION
C=======================================================================
      DO 2210 M=2,NSWAP
      PLWVEN(NBANOC+2-M)=PLWVEN(NBANOC+1-M)
      NFIND(NBANOC+2-M)=NFIND(NBANOC+1-M)
 2210 CONTINUE
      PLWVEN(NBANOC+1-NSWAP)=DATAKE(NINDX)
      NFIND(NBANOC+1-NSWAP)=NNN
      GO TO 2108
C======================================================================
C  REPEAT THE PROCEDURE FOR THE UNOCCUPIED BANDS
C======================================================================
 2107 CONTINUE
      IF(NBANDS.EQ.NBANOC)                GO TO 2108
      IF(DATAKE(NINDX).GT.PLWVEN(NBANDS)) GO TO 2108
      NSWAP=0
      DO 2310 M=1,NBANDS-NBANOC
      IF(DATAKE(NINDX).GT.PLWVEN(NBANDS+1-M)) GO TO 2400
      NSWAP=NSWAP+1
 2310 CONTINUE
 2400 CONTINUE
      DO 2410 M=2,NSWAP
      PLWVEN(NBANDS+2-M)=PLWVEN(NBANDS+1-M)
      NFIND(NBANDS+2-M)=NFIND(NBANDS+1-M)
 2410 CONTINUE
      PLWVEN(NBANDS+1-NSWAP)=DATAKE(NINDX)
      NFIND(NBANDS+1-NSWAP)=NNN
 2108 CONTINUE
C      DATAKE(NINDX+1)=HSQDTM*DATAKE(NINDX+1)**2
C      DATAKE(NINDX+2)=HSQDTM*DATAKE(NINDX+2)**2
C      DATAKE(NINDX+3)=HSQDTM*DATAKE(NINDX+3)**2
 2100 CONTINUE
C=======================================================================
C FROM THE INDICES OF THE LOWEST ENERGY BASIS STATES INITIALISE THE
C WAVEFUNCTIONS
C=======================================================================
      WRITE(*,*)' '
      DO 2500 NN=1,NBANDS
      NINDX=NRPLWV*(NN-1)
      CPTWFP(NFIND(NN)+NINDX)=(1.0,0.0)
      CELEN(NN)=(1.0,0.0)*PLWVEN(NN)
C=======================================================================
C     FIND GX, GY, GZ OF THE CURRENT COMPONENT
C=======================================================================
      M=NINDPW(NFIND(NN))
      IGX=LPCTX((M-1)     -((M-1)/   NGX   )*NGX+1)
      IGY=LPCTY((M-1)/NGX -((M-1)/(NGX*NGY))*NGY+1)
      IGZ=LPCTZ((M-1)/(NGX*NGY)                 +1)
      WRITE(*,2502) NN, IGX, IGY, IGZ, REAL(CELEN(NN)) 
 2502 FORMAT(2X,'INITIAL WAVEFUNCTION OF BAND NO.',I3,' G = (',3I4,
     &         ')   KE =',F10.5)
 2500 CONTINUE
C
      WRITE(*,*)'RETURN FROM WFINIT'
      WRITE(*,*)' '
      RETURN
      END
