/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: spawn.c   SID: 2.1 8/6/89 22:24:27
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 *  $Header: spawn.c,v 3.4 87/06/22 14:32:48 kjmcdonell Beta $
 *
 ******************************************************************************/
char SCCSid[] = "@(#) @(#)spawn.c:2.1 -- 8/6/89 22:24:27";
/*
 *  Process creation
 *
 */

main(argc, argv)
int	argc;
char	*argv[];
{
	int	iter;
	int	slave;
	int	status;

	if (argc != 2) {
		printf("Usage: %s count\n", argv[0]);
		exit(1);
	}

	iter = atoi(argv[1]);

	while (iter-- > 0) {
		if ((slave = fork()) == 0) {
			/* slave .. boring */
#if debug
			printf("fork OK\n");
#endif
			exit(0);
		} else if (slave < 0) {
			/* woops ... */
			printf("Fork failed at iteration %d\n", iter);
			perror("Reason");
			exit(2);
		} else
			wait(&status);
		if (status != 0) {
			printf("Bad wait status: 0x%x\n", status);
			exit(2);
		}
#if debug
		printf("Child %d done.\n", slave);
#endif
	}
	exit(0);
}
