/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */

#include <stdio.h>

#define PUBLIC 
#define PRIVATE static 

PRIVATE char psfname[200];
PRIVATE FILE * pf = NULL;

/* leave a margin on left and bottom */
#define XPOS 99 
#define YPOS 99 
#define MAX3(a,b,c) (((a>b)&&(a>c)) ? a : ((b > c)? b : c))
#define sfx(xval) ((xval)+=XPOS)
#define sfy(yval) ((yval)+=YPOS)


PUBLIC PSbegin(fname) char * fname; 
{
  strcpy(psfname,fname);
  pf = fopen(psfname,"w");
  fputs("%!PS-Adobe-2.0 EPSF-2.0\n",pf);
  fputs(" /jl { moveto lineto } def\n", pf);
  fprintf(stderr,"creating new postscript file [%s]...\n", psfname);
}

PUBLIC PSfinish() {
  fprintf(pf,"stroke \n showpage\n");
  fclose(pf);

  fprintf(stderr,"%c postscript file [%s] is created\n", 7, psfname);
}
PUBLIC PSsetrgbcolor(r,g,b) float r,g,b; {
	    fprintf(pf,"%f %f %f setrgbcolor\n", r,g,b);
}

PUBLIC PSstroke() 
{
	    fprintf(pf,"stroke\n");
}

PUBLIC PSdrawline (x1,y1,x2,y2) 
int x1,y1,x2,y2;
{
   PRIVATE long t=0;
   t++; if(t%200==0) fprintf(pf,"stroke\n");
	x1 = sfx(x1);
	x2 = sfx(x2);
	y1 = sfy(y1);
	y2 = sfy(y2);
   fprintf(pf,"%d %d %d %d jl\n", x1,y1,x2,y2);
}

PUBLIC PSdrawpolygon (n, xx, yy)
int n, xx[], yy[];
{
  int i;
  fprintf(pf," %d %d moveto\n", sfx(xx[0]), sfy(yy[0]));
  for(i=1;i<n;i++) {
     fprintf(pf," %d %d lineto\n", sfx(xx[i]), sfy(yy[i]));
  }
  fprintf(pf," %d %d lineto\n", sfx(xx[0]), sfy(yy[0]));
  PSstroke();
}

PUBLIC PSsetfont (fontname, fontsize) 
char * fontname; int fontsize; 
{
     fprintf(pf,"/%s findfont %d scalefont setfont\n", fontname,fontsize);
}

PUBLIC PSdrawtextat(text,x,y)
char * text;
int x,y;
{
 fprintf(pf,"%d %d moveto (%s) show\n", x, y, text);
}


PUBLIC PSsetlinewidth (w) float w; {
  fprintf(pf,"%f setlinewidth\n",w);
}

/* ------------------------------------------------------------------ */

/* postscript modules */

PRIVATE CheckCompression(image, width, height, pal, isGray)
unsigned char *image;
int width, height;
unsigned char pal[256][3];
int isGray;
{
  int cnt, c, val, prev;
  int i, j, k = 0;
  float compressFactor;

  for(j=0;j<height;j++) {
    cnt = 0;
    for(i=0;i<width;i++) {
      c = *image++;
      val = isGray ? MAX3(pal[c][0], pal[c][1], pal[c][2]) : c;
      if (cnt && (prev != val || cnt == 255)) {
	k++;
	cnt = 1;
      }
      else {
	cnt++;
      }
      prev = val;
    }
    k++;
  }

  compressFactor = isGray ?
    (float)(width*height) / (2. * (float)k) :
    (3. * (float)(width*height)) / (4. * (float)k) ;

  return  compressFactor > 1.2 ;
}

PRIVATE PSbwCompress(image, width, height, pal)
unsigned char *image;
int width, height;
unsigned char pal[256][3];
{
  int cnt, c, prev, val;
  int i, j, k = 0, l;
  float compressFactor;

  fputs("\
/datagen {\n\
                 currentfile 2 string readhexstring pop\n\
                 dup  1 get            % get value\n\
                 exch 0 get            % get repeat factor\n\
                 dup string            % create out string\n\
                 3 1 roll dup\n\
                 {\n\
                          1 sub                 % decrement counter\n\
                          3 copy                % save for next step\n\
                          exch put\n\
                 } repeat pop pop\n\
         } def\n", pf);
  fprintf(pf," %d %d 8\n", width, height);
  fprintf(pf," [%d 0 0   -%d 0 %d ]\n", width, height, height);
  fprintf(pf," {datagen}\n  image\n");

  /* ------------ B/W image ------ */
  for(j=0;j<height;j++) {
    cnt = 0; l = 0;
    for(i=0;i<width;i++) {
      c = *image++;
      val = MAX3(pal[c][0], pal[c][1], pal[c][2]);
      if (cnt && (prev != val || cnt == 255)) {
	fprintf(pf, "%02x %02x ", cnt, prev);
	l++;
	if (l%13 == 0) putc('\n', pf);
	cnt = 1;
      }
      else {
	cnt++;
      }
      prev = val;
    }
    fprintf(pf, "%02x %02x\n", cnt, prev); l++;
    k += l;
  }

  compressFactor = (float)(width*height) / (2. * (float)k);
  fprintf(stderr, "number of output pair : %d, compression = %f\n",
	  k, compressFactor);
  fprintf(pf,"\ngrestore \n");

  return compressFactor > 1. ;
}
  

PUBLIC PSputbwimage(image, width, height, pal)
unsigned char *image;
int width, height;
unsigned char pal[256][3];
{

  int c;
  unsigned char *im = image;
  int i,j;
  int ht = height, wd = width;
  
  /* ------------ init ------ */
  fprintf(pf,"gsave\n/picstr %d  string def\n",width);
  fprintf(pf," %d %d  translate\n %d %d scale\n\n", XPOS, YPOS, width, height);
  
  if (CheckCompression(image, width, height, pal, 1))
    return PSbwCompress(image, width, height, pal);

  fprintf(pf," %d %d 8\n", width, height);
  fprintf(pf," [%d 0 0   -%d 0 %d ]\n", width, height, height);
  fprintf(pf," {currentfile picstr readhexstring pop}\n  image\n");
  
  /* ------------ B/W image ------ */
  for(j=0;j<ht;j++) {
    for(i=0;i<wd;i++) {
      c = *im++;
      fprintf(pf,"%02x ", MAX3(pal[c][0], pal[c][1], pal[c][2]));
      if (i && i%30==0) putc('\n', pf);
    }
    putc('\n',pf);
  }
  fprintf(pf,"\ngrestore \n");
  printf("BLACK & WHITE\n");
}

PRIVATE PScolorCompress(image, width, height, pal)
unsigned char *image;
int width, height;
unsigned char pal[256][3];
{
  int cnt, c, prev;
  int i, j, k = 0, l;
  float compressFactor;

  fputs("\
/colorgen {\n\
                 currentfile 4 string readhexstring pop\n\
                 dup  1 3 getinterval  % get value\n\
                 exch 0 get            % get repeat factor\n\
                 dup 3 mul string      % create out string\n\
                 3 1 roll -3 exch\n\
                 {\n\
                          3 add                 % increment counter\n\
                          3 copy                % save for next step\n\
                          exch putinterval\n\
                 } repeat pop pop\n\
         } def\n", pf);
  fprintf(pf," %d %d 8\n", width, height);
  fprintf(pf," [%d 0 0   -%d 0 %d ]\n", width, height, height);
  fprintf(pf," {colorgen}\n false  3\n colorimage\n");
  
  /* --------- color image --- */
  for(j=0;j<height;j++) {
    cnt = 0; l = 0;
    for(i=0;i<width;i++) {
      c = *image++;
      if (cnt && (prev != c &&
		  (pal[c][0] != pal[prev][0] || pal[c][1] != pal[prev][1] ||
		   pal[c][2] != pal[prev][2])
		  || cnt == 255)) {
	fprintf(pf,"%02x %02x%02x%02x ", cnt, pal[prev][0], pal[prev][1],
		pal[prev][2]);
	l++;
	if (l%13 == 0) putc('\n', pf);
	cnt = 1;
      }
      else {
	cnt++;
      }
      prev = c;
    }
    fprintf(pf,"%02x %02x%02x%02x\n", cnt, pal[prev][0], pal[prev][1],
	    pal[prev][2]);
    l++;
    k += l;
  }
  compressFactor = (float)(3*width*height) / (4. * (float)k);
  fprintf(stderr, "number of output triplet : %d, compression = %f\n",
	  k, compressFactor);
  fprintf(pf,"\ngrestore \n");

  return compressFactor > 1. ;
}

PUBLIC PSputcolorimage(image, width, height,pal)
unsigned char *image;
int width, height;
unsigned char pal[256][3];
{
  int c;
  unsigned char *im = image;
  int i,j;
  int ht = height, wd = width;
  
  /* --------- init ---- */
  fprintf(pf,"gsave\n/picstr %d  string def\n",3*width);
  fprintf(pf,"%d %d 99 translate\n %d %d scale\n\n", XPOS, YPOS,width, height);
  
  if (CheckCompression(image, width, height, pal, 0))
    return PScolorCompress(image, width, height,pal);

  fprintf(pf," %d %d 8\n", width, height);
  fprintf(pf," [%d 0 0   -%d 0 %d]\n", width, height, height);
  fprintf(pf," {currentfile picstr readhexstring pop}\n false  3\n colorimage\n");
  
  /* --------- color image --- */
  
  for(j=0;j<ht;j++) {
    for(i=0;i<wd;i++) {
      c = *im++;
      fprintf(pf,"%02x%02x%02x ", pal[c][0] ,pal[c][1], pal[c][2] );
      if (i%10==0) fprintf(pf,"\n");
    }
    fprintf(pf,"\n");
  }
  fprintf(pf,"\ngrestore \n");
  printf("COLOUR\n");
}

/* ================================================================== */

