/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: control.c,v 1.13 1993/08/27 21:35:22 davet Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/Separator.h>
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>

#include "collageP.h"
#include "view.h"
#include "list.h"
#include "net.h"
#include "txtUI.h"


#define MAIN_WIDTH	400
#define DP_WIDTH	40
#define DP_HEIGHT	40


#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif


extern void CBIntroDone();
extern void CBExit();
extern void CBLoadFile();
extern void CBLoadAnimation();
extern void CBGrabRasProc();
extern void CBJoinSession();
extern void CBBeginSession();
extern void CBNewText();
extern void CBNewWhiteboard();
extern void InitLegend();
extern void MakePrivateRaster();
extern int NetSendDataObject();
extern Widget InitColorBar();
extern TextUI *TextSearchByName();
extern void CBDisplayServerLocation();
extern void CBTimeToLoadFiles();
extern void CBChatBoxOpen();
extern void CBNetControls();


extern NetPort *outP;
extern Display *myDpy;
extern GC drawAreaGC;
extern Pixmap DataIn, DataOut;
extern XtAppContext app;
extern List fileLoadList;


/* Widget inLabel, outLabel; */
/* Widget dtmList */
Widget legendList;
static Widget legendFrame, legendLab;
Widget netButton;
static Boolean ShowFeedback;
static Boolean ShowLegend;
Boolean EricBuff;
static Widget menuBar;
static Widget popPulldown;
/* EJB
static Widget dataPulldown;
static Widget dataButton;
*/
static Boolean controlLock = False;
List vList;

static Widget loadButton;
static Widget loadAnimButton;
static Widget grabRasterButton;


struct pop_rec {
	View *V;
	Widget shell;
	Widget button;
	Boolean up;
};



static void
CBMapChange(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	struct pop_rec *pptr = (struct pop_rec *)client_data;

	if ((event->type == MapNotify)||(event->type == UnmapNotify))
	{
		if (event->type == MapNotify)
		{
			if (pptr->V)
			{
				pptr->V->isUp = True;
			}
			pptr->up = True;
			XmToggleButtonGadgetSetState(pptr->button, True, False);
		}
		else if (event->type == UnmapNotify)
		{
			if (pptr->V)
			{
				pptr->V->isUp = False;
			}
			pptr->up = False;
			XmToggleButtonGadgetSetState(pptr->button, False,False);
		}
	}
}


static void
CBToggleOption(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Boolean *Optr = (Boolean *)client_data;

	if (*Optr == True)
	{
		*Optr = False;
	}
	else
	{
		*Optr = True;
	}
}


static void
CBTogglePopup(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	struct pop_rec *pptr = (struct pop_rec *)client_data;
	int set = ((XmToggleButtonCallbackStruct *)call_data)->set;

	if (pptr->up)
	{
		XRaiseWindow(myDpy, XtWindow(pptr->shell));
/* EJB
		XtPopdown(pptr->shell);
		if (pptr->V)
		{
			pptr->V->isUp = False;
		}
		pptr->up = False;
*/
	}
	else
	{
		XtPopup(pptr->shell, XtGrabNone);
		if (pptr->V)
		{
			pptr->V->isUp = True;
		}
		pptr->up = True;
	}
	if (!set)
	  XmToggleButtonGadgetSetState(pptr->button, True, False);
}


void
RegisterPopup(proot, name, startup, V)
	Widget proot;
	char *name;
	Boolean startup;
	View *V;
{
	Widget b;
	Arg argList[30];
	Cardinal i;
	XmString label;
	struct pop_rec *pptr;

	pptr = (struct pop_rec *)MALLOC(sizeof(struct pop_rec));
	if (pptr != NULL)
	{
		pptr->shell = proot;
		pptr->up = startup;
		pptr->V = V;
	}

	i = 0;
	label = XmStringCreateSimple(name);
        XtSetArg(argList[i], XmNmnemonic, name[0]); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(popPulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBTogglePopup, (caddr_t)pptr);
	XtManageChild(b);
	XmStringFree(label);

	pptr->button = b;

	if (startup)
	{
		XtPopup(proot, XtGrabNone);
	}

	XtAddEventHandler(proot, StructureNotifyMask, 0, CBMapChange,
			(caddr_t)pptr);
	if (V) {
		ListAddEntry(vList,V);
		}
}


void
RegisterData(data)
	Cdata *data;
{
	Widget b;
	Arg argList[30];
	Cardinal i;
	XmString label;
	struct pop_rec *pptr;

/* EJB
	XtSetSensitive(dataButton, True);
*/

	pptr = (struct pop_rec *)MALLOC(sizeof(struct pop_rec));
	if (pptr != NULL)
	{
		pptr->shell = data->V->shell;
		pptr->up = True;
		pptr->V = data->V;
	}

	i = 0;
	label = XmStringCreateSimple(data->name);
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(popPulldown, "toggleButton", argList,i);
	XtAddCallback(b, XmNvalueChangedCallback, CBTogglePopup, (caddr_t)pptr);
	XtManageChild(b);
	XmStringFree(label);

	pptr->button = b;

	XtAddEventHandler(data->V->shell, StructureNotifyMask, 0, CBMapChange,
			(caddr_t)pptr);
	if (data->V) {
		ListAddEntry(vList,data->V);
		ControlLock(controlLock);
		}
}


static void
CBToggleLegend(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	CBToggleOption(w, client_data, call_data);

	if (ShowLegend == False)
	{
		XtUnmanageChild(legendList);
		XtUnmanageChild(legendFrame);
	}
	else
	{
		XtManageChild(legendFrame);
		XtManageChild(legendList);
	}
}

static void
CBAnimFromMem(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
int set = ((XmToggleButtonCallbackStruct *)call_data)->set;

	if (set)
		if (client_data == (caddr_t)1) /* call for mem source*/
			res_gotten.anim_source = "memory";
		else if (client_data == (caddr_t)2)
			res_gotten.anim_source = "disk";
		else
			res_gotten.anim_source = "server";
}

static void CBScaleImage(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	res_gotten.scaleImage=((XmToggleButtonCallbackStruct *)call_data)->set;
}


void
InitControl(rootW)
	Widget rootW;
{
	Widget mainWindow, f1 /*, f2, d2 */ ;
	Widget animPulldown,pulldown, b;
	Arg argList[30];
	Cardinal i;
	XmString label;

	/*
	 * Create the main window area, which is a form widget containing
	 * a menubar, 2 drawing areas and 2 list widgets
	 */
	i = 0;
        XtSetArg(argList[i], XmNshadowThickness, 0); i++;
	mainWindow = XmCreateForm(rootW, "Main Control", argList, i);
	XtManageChild(mainWindow);


	/*
	 * Create the menubar to hang all our menus off of
	 */
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	menuBar = XmCreateMenuBar(mainWindow, "Control Bar", argList, i);
	XtManageChild(menuBar);

	/*
	 * File menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("File");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'F'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Open");
        XtSetArg(argList[i], XmNmnemonic, 'O'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	loadButton = XmCreatePushButtonGadget(pulldown, "menuButton", 
				argList, i);
	XtAddCallback(loadButton, XmNactivateCallback, CBLoadFile, NULL);
	XtManageChild(loadButton);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Open Animation");
        XtSetArg(argList[i], XmNmnemonic, 'A'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	loadAnimButton = XmCreatePushButtonGadget(pulldown, "menuButton", 
				argList, i);
	XtAddCallback(loadAnimButton, XmNactivateCallback, 
				CBLoadAnimation, NULL);
	XtManageChild(loadAnimButton);
	XmStringFree(label);

        i=0;
        b = XmCreateSeparator(pulldown,"separator", argList,i);
        XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Quit");
        XtSetArg(argList[i], XmNmnemonic, 'Q'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBExit, NULL);
	XtManageChild(b);
	XmStringFree(label);

/*EJB
	i = 0;
	label = XmStringCreateSimple("In");
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, SetReadFeedback, NULL);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Out");
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, SetWriteFeedback, NULL);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("None");
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, UnsetFeedback, NULL);
	XtManageChild(b);
	XmStringFree(label);
*/

	/*
	 * Windows menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	popPulldown = XmCreatePulldownMenu(menuBar, "pulldown",
		argList, i);

	i = 0;
	label = XmStringCreateSimple("Windows");
	XtSetArg(argList[i], XmNsubMenuId, popPulldown); i++;
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'W'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	/*
	 * Data menu
	 */
/* EJB
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	dataPulldown = XmCreatePulldownMenu(popPulldown, "pulldown",
		argList, i);

	i = 0;
	label = XmStringCreateSimple("Data Views");
	XtSetArg(argList[i], XmNsubMenuId, dataPulldown); i++;
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'D'); i++;
	dataButton = XmCreateCascadeButton(popPulldown, "viewer", argList, i);
	XtManageChild(dataButton);
	XtSetSensitive(dataButton, False);
	XmStringFree(label);
*/

	/*
	 * Tools menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Tools");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'T'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

#ifndef MAC_COMPAT
	i = 0;
	label = XmStringCreateSimple("New Text Window");
        XtSetArg(argList[i], XmNmnemonic, 'T'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b, XmNactivateCallback, 
						CBNewText, NULL);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("New Whiteboard");
        XtSetArg(argList[i], XmNmnemonic, 'W'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b, XmNactivateCallback, 
						CBNewWhiteboard, NULL);
	XtManageChild(b);
	XmStringFree(label);
#endif /* ! MAC_COMPAT */

	i = 0;
	label = XmStringCreateSimple("Screen Capture");
        XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	grabRasterButton = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(grabRasterButton, XmNactivateCallback, 
						CBGrabRasProc, NULL);
	XtManageChild(grabRasterButton);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Chat Box");
        XtSetArg(argList[i], XmNmnemonic, 'B'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b , XmNactivateCallback, CBChatBoxOpen, NULL);
	XtManageChild(b);
	XmStringFree(label);

	/*
	 * Collaborate menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Collaborate");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Begin Session");
        XtSetArg(argList[i], XmNmnemonic, 'B'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b, XmNactivateCallback, CBBeginSession, (XtPointer)rootW);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Join Session");
        XtSetArg(argList[i], XmNmnemonic, 'J'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b, XmNactivateCallback, CBJoinSession, (XtPointer)rootW);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Server Location");
        XtSetArg(argList[i], XmNmnemonic, 'L'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b, XmNactivateCallback, CBDisplayServerLocation, 
					(XtPointer)rootW);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Network Controls");
        XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", 
						argList, i);
	XtAddCallback(b, XmNactivateCallback, CBNetControls, 
					(XtPointer)rootW);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Show Local Activity");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'A'); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
        XtSetArg(argList[i], XmNset, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBToggleOption,
		(caddr_t)&ShowFeedback);
	ShowFeedback = True;
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Show Participants");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
        XtSetArg(argList[i], XmNset, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBToggleLegend,
		(caddr_t)&ShowLegend);
	ShowLegend = True;
	XtManageChild(b);
	XmStringFree(label);

	/*
	 * Option menu
	 */

	i = 0;
	XtSetArg(argList[i], XmNradioBehavior, False); i++;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Options");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'O'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	XtSetArg(argList[i], XmNradioBehavior, True); i++;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	animPulldown = XmCreatePulldownMenu(pulldown, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Animation Options");
        XtSetArg(argList[i], XmNsubMenuId, animPulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'O'); i++;
	b = XmCreateCascadeButton(pulldown, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);
		      
	i = 0;
	label = XmStringCreateSimple("Animate from server");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	if (!strcmp(res_gotten.anim_source, "server"))
		XtSetArg(argList[i], XmNset, True), i++;
	b = XmCreateToggleButtonGadget(animPulldown,"toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBAnimFromMem,(caddr_t)0);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Animate from memory");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	if (!strcmp(res_gotten.anim_source, "memory"))
		XtSetArg(argList[i], XmNset, True), i++;
	b = XmCreateToggleButtonGadget(animPulldown,"toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBAnimFromMem,(caddr_t)1);
	XtManageChild(b);
	XmStringFree(label);
		      
	i = 0;
	label = XmStringCreateSimple("Animate from disk");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	if (!strcmp(res_gotten.anim_source, "disk"))
		XtSetArg(argList[i], XmNset, True), i++;
	b = XmCreateToggleButtonGadget(animPulldown,"toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBAnimFromMem,(caddr_t)2);
	XtManageChild(b);
	XmStringFree(label);

	i=0;
        XtSetArg(argList[i], XmNorientation,XmHORIZONTAL); i++;
	b = XmCreateSeparator(pulldown,"separator", argList,i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Scale Loaded Image");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
        XtSetArg(argList[i], XmNindicatorType, XmN_OF_MANY); i++;
        XtSetArg(argList[i], XmNset, SHOULD_SCALE_IMAGE); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBScaleImage,(caddr_t)0);
	XtManageChild(b);
	XmStringFree(label);

/* EJB
	i = 0;
	label = XmStringCreateSimple("Text Buffering");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
        XtSetArg(argList[i], XmNset, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "toggleButton", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBToggleOption,
		(caddr_t)&EricBuff);
	EricBuff = True;
	XtManageChild(b);
	XmStringFree(label);
*/
	EricBuff = True;

	/*
	 * DTM menu
	 */
/*
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("DTM");
        XtSetArg(argList[i], XmNrecomputeSize, False); i++;
        XtSetArg(argList[i], XmNwidth, DP_WIDTH); i++;
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'D'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("<IN>  ");
        XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
	inLabel = XmCreateLabel(pulldown, "Label", argList, i);
	XtManageChild(inLabel);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("<OUT> ");
        XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
	outLabel = XmCreateLabel(pulldown, "Label", argList, i);
	XtManageChild(outLabel);
	XmStringFree(label);
*/

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_IN); i++;
/*
        XtSetArg(argList[i], XmNshadowThickness, 2); i++;
*/
	f1 = XmCreateFrame(mainWindow, "frame1", argList, i);
	XtManageChild(f1);

	i = 0;
	XtSetArg(argList[i], XmNwidth, DP_WIDTH); i++;
	XtSetArg(argList[i], XmNheight, DP_HEIGHT); i++;
	netButton = XmCreateDrawingArea(f1, "feedback", argList, i);
	XtManageChild(netButton);

/*
	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, f1); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_IN); i++;
        XtSetArg(argList[i], XmNshadowThickness, 2); i++;
        XtSetArg(argList[i], XmNmarginWidth, 2); i++;
        XtSetArg(argList[i], XmNmarginHeight, 2); i++;
	f2 = XmCreateFrame(mainWindow, "frame2", argList, i);
	XtManageChild(f2);

	d2 = InitColorBar(f2, 256, (DP_HEIGHT - 4));
	XtManageChild(d2);

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, f1); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_POSITION); i++;
	XtSetArg(argList[i], XmNrightPosition, 50); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNwidth, (MAIN_WIDTH / 2)); i++;
	XtSetArg(argList[i], XmNvisibleItemCount, 3); i++;
	dtmList = XmCreateScrolledList(mainWindow, "List1", argList, i);
	XtManageChild(dtmList);
*/

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, f1); i++;
	XtSetArg(argList[i], XmNshadowType, XmSHADOW_IN); i++;
	legendFrame = XmCreateFrame(mainWindow, "Frame", argList, i);
	XtManageChild(legendFrame);

	label = XmStringCreateSimple("Participants:");
	i = 0;
/*
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, f1); i++;
*/
        XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
	legendLab = XmCreateLabel(legendFrame, "List2", argList, i);
	XtManageChild(legendLab);
	XmStringFree(label);

/*
        i=0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, legendLab); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, f1); i++;
        b = XmCreateSeparator(mainWindow,"separator", argList,i);
        XtManageChild(b);
*/

	i = 0;
	XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNtopWidget, legendFrame); i++;
	XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, f1); i++;
	XtSetArg(argList[i], XmNwidth, (MAIN_WIDTH - DP_WIDTH - 4)); i++;
	XtSetArg(argList[i], XmNvisibleItemCount, 3); i++;
	legendList = XmCreateScrolledList(mainWindow, "List2", argList, i);
	XtManageChild(legendList);

/*
	label = XmStringCreateSimple("<DTM IN>  ");
	XmListAddItem(dtmList, label, 1);
	XmStringFree(label);
	label = XmStringCreateSimple("<DTM OUT> ");
	XmListAddItem(dtmList, label, 2);
	XmStringFree(label);
*/

	InitLegend();

	if (ListHead(fileLoadList) == NULL)
		XtAddEventHandler(netButton, ExposureMask, 0, CBIntroDone,
				  (caddr_t)NULL);
/*
	XtAddEventHandler(netButton, ExposureMask, 0, CBTimeToLoadFiles,
		(caddr_t)NULL);
*/
	XtAppAddTimeOut(app, 1000, CBTimeToLoadFiles, (caddr_t) 0);

	vList = ListCreate();

	/*
	 * I have to set this again here because Motif is STUUUUPID!
	 */
	i = 0;
        XtSetArg(argList[i], XmNshadowThickness, 0); i++;
	XtSetValues(mainWindow, argList, i);
}


void
SetReadFeedback()
{
	Arg argList[30];
	Cardinal i;
	Dimension width, height, shadow;
	int x, y, w, h;

	if (ShowFeedback == False)
	{
		return;
	}

	i = 0;
	XtSetArg(argList[i], XmNwidth, &width); i++;
	XtSetArg(argList[i], XmNheight, &height); i++;
	XtGetValues(netButton, argList, i);

/*
	i = 0;
	XtSetArg(argList[i], XmNshadowThickness, &shadow); i++;
	XtGetValues(XtParent(netButton), argList, i);
*/
	shadow = 0;

	x = shadow;
	y = shadow;
	w = width - (2 * shadow);
	h = height - (2 * shadow);
	if (w > DP_WIDTH)
	{
		x = x + ((w - DP_WIDTH) / 2);
		w = DP_WIDTH;
	}
	if (h > DP_HEIGHT)
	{
		y = y + ((h - DP_HEIGHT) / 2);
		h = DP_HEIGHT;
	}

	XCopyArea(myDpy, DataIn, XtWindow(netButton), drawAreaGC,
		0, 0, w, h, x, y);

	XFlush(myDpy);
}


void
SetWriteFeedback()
{
	Arg argList[30];
	Cardinal i;
	Dimension width, height, shadow;
	int x, y, w, h;

	if (ShowFeedback == False)
	{
		return;
	}

	i = 0;
	XtSetArg(argList[i], XmNwidth, &width); i++;
	XtSetArg(argList[i], XmNheight, &height); i++;
	XtGetValues(netButton, argList, i);

/*
	i = 0;
	XtSetArg(argList[i], XmNshadowThickness, &shadow); i++;
	XtGetValues(XtParent(netButton), argList, i);
*/
	shadow = 0;

	x = shadow;
	y = shadow;
	w = width - (2 * shadow);
	h = height - (2 * shadow);
	if (w > DP_WIDTH)
	{
		x = x + ((w - DP_WIDTH) / 2);
		w = DP_WIDTH;
	}
	if (h > DP_HEIGHT)
	{
		y = y + ((h - DP_HEIGHT) / 2);
		h = DP_HEIGHT;
	}

	XCopyArea(myDpy, DataOut, XtWindow(netButton), drawAreaGC,
		0, 0, w, h, x, y);

	XFlush(myDpy);
}


void
UnsetFeedback()
{

	if (ShowFeedback == False)
	{
		return;
	}

	XClearArea(myDpy, XtWindow(netButton), 0, 0, 0, 0, True);
	XFlush(myDpy);
}


ControlLock(lock)
Boolean lock;
{
View *V;

	controlLock = lock;
	XtSetSensitive(loadButton,!lock);
	XtSetSensitive(loadAnimButton,!lock);
	XtSetSensitive(grabRasterButton,!lock);

        V= (View *) ListHead(vList);
        while(V) {
		if (lock) {
			SetMode(V->lastToggle,V,V->Mode);
			}
                if (V->optionMenu) {
                        XtSetSensitive(V->optionMenu,!lock);
                        }
                if (V->operationMenu) {
                        XtSetSensitive(V->operationMenu,!lock);
                        }
                V= (View *) ListNext(vList);
                }
}


/*ARGSUSED*/
void
CBPublish(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	Cardinal i;
	Arg argList[15];
	View *V = (View *)client_data;
	char tlab[256];
	Data *d;
	Palette *p;
	TextUI *text;

	if ((outP == NULL)||(V == NULL))
	{
		return;
	}

	sprintf(tlab, "Public %s", V->cData->name);

	i = 0;
	XtSetArg(argList[i], XtNtitle, tlab); i++;
	XtSetValues(V->shell, argList, i);

	d = DataNew();
	d->label = (char *)MALLOC(strlen(V->cData->name) + 1);
	strcpy(d->label, V->cData->name);
	d->entity = ENT_Network;
	d->view_type = V->type;

	switch (V->type)
	{
		case V_RASTER:
		case V_WHITEBOARD:
			d->dot = DOT_Array;
			d->dost = DOST_Char;
			d->dim[0] = V->cData->xdim;
			d->dim[1] = V->cData->ydim;
			d->data = V->cData->buff;
			if ((V->cData->type == D_FLOAT ||
			     V->cData->type == D_INT) && V->next)
			  {
				d->associated = (char *)
				  MALLOC(strlen(V->next->cData->name)+1);
				strcpy(d->associated,V->next->cData->name);
				d->min = V->cData->min;
				d->max = V->cData->max;
				d->expandX = (float)V->cData->xmag;
				d->expandY = (float)V->cData->ymag;
			  }
			d->rank = 2;
			if (V->cData->hasPalette)
			{
				p = V->cData->pal;
				d->group = DataNew();
				d->group->label = (char *)
					MALLOC(strlen(p->name) + 1);
				strcpy(d->group->label, p->name);
				d->group->entity = ENT_Network;
				d->group->dot = DOT_Palette8;
				d->group->dost = DOST_Char;
				d->group->rank = 1;
				d->group->dim[0] = 768;
				d->group->data = p->rgb;
				d->group->group = NULL;
			}
			else
			{
				d->group = NULL;
			}
			(void)NetSendDataObject(outP, d, True, False,
					"Publisher");
			break;
		case V_SHEET:
			d->dot = DOT_Array;
			d->rank = 2;
			d->dim[0] = V->cData->xdim;
			d->dim[1] = V->cData->ydim;
			if (V->cData->type == D_CHAR)
			{
				d->dost = DOST_Char;
				d->data = (GenericPtr)V->cData->buff;
			}
			else if (V->cData->type == D_INT)
			{
				d->dost = DOST_Int32;
				d->data = (GenericPtr)V->cData->fbuff;
			}
			else if (V->cData->type == D_FLOAT)
			{
				d->dost = DOST_Float;
				d->data = (GenericPtr)V->cData->fbuff;
			}
			d->min = V->cData->min;
			d->max = V->cData->max;
			d->group = NULL;
			(void)NetSendDataObject(outP, d, True, False,
					"Publisher");
			break;
		case V_TEXT:
			d->dot = DOT_Text;
			d->dost = DOST_Char;
			d->rank = 1;
			d->data = (GenericPtr)XmTextGetString(V->drawArea);
			d->dim[0] = strlen(d->data);
			d->group = NULL;
			(void)NetSendDataObject(outP, d, True, False,
					"Publisher");
			text = TextSearchByName(V->cData->name);
			if (text != NULL)
			{
				text->ispub = True;
			}
			break;
	}

	V->ispub = True;
}


void
CBMakePrivate(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;

	if ((V == NULL)||(V->ispub != True))
	{
		return;
	}

	switch(V->type)
	{
		case V_RASTER:
			MakePrivateRaster(V);
		case V_WHITEBOARD:
			break;
		case V_SHEET:
			break;
		case V_TEXT:
			break;
	}
}

