/* nbraw.c Version 0. 7 Feb 1992 Steven Bjork, Telebit Corp. */
/* Driver for printer hung off a NetBlazer. */
/* Raw version. */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <syslog.h>

#include "nblp.h"

main(argc, argv)
int argc;
char *argv[];
{
  int s, len, sockfd;
  struct sockaddr_in sa;
  struct hostent *hp;
  struct servent *sp;
  char *pname;
  char hname[MAXLINE];

  pname = argv[0];

/* Get host name by stripping off last two characters of our name. */
  strncpy(hname, pname, (strlen(pname) - 2));

  if ((hp = gethostbyname(hname)) == NULL) {
    logme("Host name lookup failure.");
    exit(1);
  }

/* Copy host address type data structures. */
  bcopy((char *)hp->h_addr, (char *)&sa.sin_addr, hp->h_length);
  sa.sin_family = hp->h_addrtype;

  if ((sp = getservbyname("telnet", "tcp")) == NULL) {
    logme("Telnet service lookup failure.");
    exit(1);
  }

/* Set our raw port value. This is 7000 + line number. */
  sa.sin_port = NBRAWPORT + atoi(pname + (strlen(pname) - 2));

/* Open the socket. */
  if ((s = socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0 ) {
    logme("Socket open failure.");
    exit(1);
  }

/* Try to get there from here. */
  if (connect(s, &sa, sizeof(sa)) < 0) {
    logme("Connect failure.");
    exit(1);
  }

/* Start shoveling the bits. */
  stdin2sock(stdin, s);
  wait();
  close(s);
  exit(0);
}

stdin2sock(fp, sockfd)

register FILE *fp;
register int sockfd;

{
  int n;
  char *ptr;
  char sendline[MAXLINE +2];

/* Need to map \n into \r\n. Sigh, very messy. */

  while (fgets(sendline, MAXLINE, fp) != NULL) {
    n = strlen(sendline);
    ptr = sendline + n;
    if (*--ptr == '\n' ) {
       *ptr++ = '\r';
       *ptr = '\n';
      n++;
    }
    if (writen(sockfd, sendline, n) != n) {
      logme("Write error on socket.");
      exit(1);
    }
    if (ferror(fp)) {
      logme("File read error.");
      exit(1);
    }
  }
}

writen(fd, ptr, nbytes)
register int fd;
register char *ptr;
register int nbytes;
{
  int nleft, nwritten;
  nleft = nbytes;
  while (nleft > 0) {
    nwritten = write(fd, ptr, nleft);
    if (nwritten <= 0)
      return(nwritten);
    nleft -= nwritten;
    ptr += nwritten;
  }
  return(nbytes - nleft);
}
