# $Header: sd_start.tcl,v 1.1 92/12/01 06:39:02 van Exp $ (LBL)
#
# NOTE: This file is provided for reference purposes.  The code
#       shown here is compiled into sd.  DON'T use this as your
#	sd startup file (~/.sd.tcl).
#
# tcl 'hooks' invoked when sd takes some action on a session.
#
# sd will invoke:
#	start_session	when the user asks to 'open' (start) a session
#	create_session	just after the user creates a new session
#	heard_session	when announcement for a session is first heard
#	delete_session	when the user or a timeout deletes a session
#
# When any of the above are invoked, the global array sd_sess
# contains all the information about the session to be started:
#   sd_sess(name)
#   sd_sess(description)
#   sd_sess(address)
#   sd_sess(ttl)
#   sd_sess(creator)
#   sd_sess(creator_id)
#   sd_sess(source_id)
#   sd_sess(arrival_time)
#   sd_sess(start_time)
#   sd_sess(end_time)
#   sd_sess(attributes)		(list of session attributes)
#   sd_sess(media)		(list of media names)
#
# For each media name there is an array containing the information
# about that media:
#   sd_$media(port)
#   sd_$media(conf_id)
#   sd_$media(attributes)	(list of media attributes)
#
# Media and session attributes are strings of the form "name" or
# "name:value".
#
# Some global state information is available in array sd_priv:
#   sd_priv(audio)		(= 0 if audio disabled with -a)
#   sd_priv(video)		(= 0 if video disabled with -v)
#   sd_priv(whiteboard)		(= 0 if wb disabled with -w)

proc start_session {} {
	global sd_sess sd_priv

	# invoke the appropriate start proc for each of the media
	# if such a proc exists and that media is enabled.
	foreach m $sd_sess(media) {
		if { [llength [info proc start_$m]] > 0 && $sd_priv($m) } {
			start_$m
		}
	}
}

proc start_audio {} {
	global sd_sess sd_audio
	set audiofmt ""
	set packetfmt "-n"
	foreach a $sd_audio(attributes) {
		case $a {
			fmt:* { set audiofmt [string range $a 4 end] }
			vt  { set packetfmt "-v" }
		}
	}
	set confaddr [format "%s/%s/%s/%s/%s" $sd_sess(address) \
		$sd_audio(port) $sd_audio(conf_id) $audiofmt $sd_sess(ttl)]

	global vat
	exec $vat -C $sd_sess(name) $packetfmt $confaddr &
}

proc start_video {} {
	global sd_sess sd_video
	set videofmt "ivs"
	foreach a $sd_video(attributes) {
		case $a {
			fmt:* { set videofmt [string range $a 4 end] }
		}
	}
	case $videofmt {
		nv {
			global nv
			exec $nv -ttl $sd_sess(ttl) $sd_sess(address) \
				$sd_video(port) &
		}
		ivs {
			global ivs
			exec $ivs -a -r -t $sd_sess(ttl) \
				-i $sd_sess(address) &
		}
	}
}

proc start_whiteboard {} {
	global sd_sess sd_whiteboard wb
	exec $wb -t $sd_sess(ttl) -p $sd_whiteboard(port) \
		$sd_sess(address) &
}

proc create_session {} { }
proc heard_session {} { }
proc delete_session {} { }

# set up the command names

set vat vat
set nv nv
set ivs ivs
set wb wb

# invoke user's startup proc (if any)

if { [file readable ~/.sd.tcl] } {
	source ~/.sd.tcl
}
