#include <stdio.h>
#include <string.h>
#include <gdbm.h>
#include "util.h"
#include "url.h"

/*
 *  DEBUG: section  47, level 1               Gatherer update (work in progress)
 */

static char *mapfile;
static GDBM_FILE mapdb;

void usage(me)
     char *me;
{
	fprintf(stderr, "usage: %s PRODUCTION.gdbm\n", me);
	exit(1);
}


/*
 * update_url()
 *
 * Return:
 *      0       Success, URL exists
 *      1       Unknown if URL exists
 *      2       URL does not exist
 */
int update_url(url)
     char *url;
{
	URL *up;
	int get_code;

	Debug(47, 1, ("update: %s\n", url));

	if ((up = url_open(url)) == NULL) {
		log("MISSING: %s\n", url);
		return 0;
	}
	get_code = url_retrieve(up);
	if (get_code == 0) {
		log("PRESENT: %s\n", url);
		url_close(up);
		return 0;
	} else if (get_code < 10) {
		log("UNKNOWN: %s\n", url);
		url_close(up);
		return 1;
	} else {
		log("MISSING: %s\n", url);
		url_close(up);
		return 2;
	}
	return 2;		/* just in case */
}


int main(argc, argv)
     int argc;
     char *argv[];
{
	datum k, nextkey, d;
	int i;
	char *url;

	init_log(stderr, stderr);

	if (argc != 2)
		usage(argv[0]);

	mapfile = argv[1];
	mapdb = gdbm_open(mapfile, 0, GDBM_READER, 0644, NULL);
	if (mapdb == NULL) {
		errorlog("gdbm_open: %s: %s\n", mapfile,
		    gdbm_strerror(gdbm_errno));
		exit(1);
	}
	k = gdbm_firstkey(mapdb);
	while (k.dptr) {
		nextkey = gdbm_nextkey(mapdb, k);
		d = gdbm_fetch(mapdb, k);
		url = xmalloc(k.dsize + 1);
		memcpy(url, k.dptr, k.dsize);
		*(url + k.dsize) = 0;
		free(k.dptr);
		free(d.dptr);
		k = nextkey;

		update_url(url);
	}
	gdbm_close(mapdb);
	exit(0);
}
