/*
 * Ascii magic -- file types that we know based on keywords
 * that can appear anywhere in the file.
 *
 * Copyright (c) Ian F. Darwin, 1987.
 * Written by Ian F. Darwin.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or of the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. The author is not responsible for the consequences of use of this
 *    software, no matter how awful, even if they arise from flaws in it.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Since few users ever read sources,
 *    credits must appear in the documentation.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.  Since few users
 *    ever read sources, credits must appear in the documentation.
 *
 * 4. This notice may not be removed or altered.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "file.h"
#include "names.h"

#ifndef	lint
static char *moduleid =
"@(#)/projects/agile/cvs/harvest/src/gatherer/essence/file/ascmagic.c,v 1.5 1996/01/05 00:47:54 duane Exp";
#endif /* lint */

char *ckfmsg = "write error on output";

			/* an optimisation over plain strcmp() */
#define	STREQ(a, b)	(*(a) == *(b) && strcmp((a), (b)) == 0)

#ifndef MAKE_LIBRARY_ONLY
#define Return(a)	return(a)
#else
static char typebuf[BUFSIZ];
#define Return(a)	return((char *) typebuf)
#undef ckfputs
#define ckfputs(a,b) 	strcpy(typebuf, a)
char *
#endif
     ascmagic(buf, mynbytes)
     register char *buf;
     int mynbytes;
{
	register int i;
	char *s, *strtok(), *token;
	register struct names *p;
	short has_escapes = 0;
#ifdef MAKE_LIBRARY_ONLY
	typebuf[0] = '\0';
#endif

	/* these are easy, do them first */

	/*
	 * for troff, look for . + letter + letter;
	 * this must be done to disambiguate tar archives' ./file
	 * and other trash from real troff input.
	 */
	if (*buf == '.' &&
	    isascii(*(buf + 1)) && isalnum(*(buf + 1)) &&
	    isascii(*(buf + 2)) && isalnum(*(buf + 2))) {
		ckfputs("troff or preprocessor input text", stdout);
		Return(1);
	}
	if ((*buf == 'c' || *buf == 'C') &&
	    isascii(*(buf + 1)) && isspace(*(buf + 1))) {
		ckfputs("fortran program text", stdout);
		Return(1);
	}
	/* look for tokens from names.h - this is expensive! */
	s = buf;
	while ((token = strtok(s, " \t\n\r\f")) != NULL) {
		s = NULL;	/* make strtok() keep on tokin' */
		for (p = names; p < names + NNAMES; p++) {
			if (STREQ(p->name, token)) {
				ckfputs(types[p->type], stdout);
				Return(1);
			}
		}
	}

	/* This is_tar() stomps all over your memory buffer! Rely on .tar */
#ifdef USE_BROKEN_IS_TAR
	switch (is_tar(buf)) {
	case 1:
		ckfputs("tar archive", stdout);
		Return(1);
	case 2:
		ckfputs("POSIX tar archive", stdout);
		Return(1);
	}
#endif

	for (i = 0; i < mynbytes; i++) {
		if (!isascii(*(buf + i)))
			Return(0);	/* not all ascii */
		if (*(buf + i) == '\033')	/* ascii ESCAPE */
			has_escapes++;
	}

	/* all else fails, but it is ascii... */
	if (has_escapes) {
		ckfputs("ascii text (with escape sequences)", stdout);
	} else {
		ckfputs("ascii text", stdout);
	}
	Return(1);
}
