static char rcsid[] = "template2db.c,v 1.17 1996/01/04 03:46:45 duane Exp";
/*
 *  template2db - Converts SOIF templates to GDBM format
 *
 *  Usage: template2db database [template template ...]
 *
 *  Darren Hardy, hardy@cs.colorado.edu, April 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */

#include <stdio.h>
#include <string.h>
#include <gdbm.h>
#include "util.h"
#include "template.h"

static void usage()
{
	fprintf(stderr, "Usage: template2db database [tmpl tmpl...]\n");
	exit(1);
}


static void add_templates(dbf, filename)
     GDBM_FILE dbf;
     char *filename;
{
	Template *t;
	Buffer *b;
	FILE *fp;
	datum d, k;

	if (!strcmp(filename, "-")) {
		fp = stdin;
	} else {
		if ((fp = fopen(filename, "r")) == NULL) {
			log_errno(filename);
			return;
		}
	}

	init_parse_template_file(fp);
	while (1) {
		t = parse_template();
		if (t == NULL && is_parse_end_of_input())
			break;
		if (t == NULL)
			continue;

		b = init_print_template(NULL);
		print_template(t);

		k.dptr = strdup(t->url);
		k.dsize = strlen(k.dptr) + 1;	/* include last '\0' */
		d.dptr = b->data;
		d.dsize = b->length;
		if (gdbm_store(dbf, k, d, GDBM_INSERT))
			errorlog("gdbm_store: %s: %s\n", k.dptr,
			    gdbm_strerror(gdbm_errno));

		finish_print_template();
		free_template(t);
		xfree(k.dptr);
	}
	finish_parse_template();
	fclose(fp);
	exit(0);
}

int main(argc, argv)
     int argc;
     char *argv[];
{
	GDBM_FILE dbf;

	init_log3("template2db", NULL, stderr);
	if (--argc < 1)
		usage();
	dbf = gdbm_open(*++argv, 0, GDBM_NEWDB | GDBM_FAST, 0644, NULL);
	if (dbf == NULL) {
		errorlog("gdbm_open: %s: %s\n", *argv, gdbm_strerror(gdbm_errno));
		log_errno(*argv);
		exit(1);
	}
	if (--argc < 1) {
		add_templates(dbf, "-");
	} else {
		for (argv++; argc > 0; argc++, argv--) {
			add_templates(dbf, *argv);
		}
	}
	gdbm_close(dbf);
	exit(0);
}
