static char rcsid[] = "gdbmsort.c,v 1.15 1996/01/17 10:07:49 duane Exp";
/*
 *  gdbmsort - Print the data items of an entire GDBM database, sorted by key.
 *
 *  Darren Hardy, hardy@cs.colorado.edu, March 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gdbm.h>
#include "util.h"

extern int usage();

static char *mapfile;
static GDBM_FILE mapdb;

int do_sort(argc, argv)
     int argc;
     char *argv[];
{
	datum k, nextkey, d;
	static char tmpfile[BUFSIZ];
	static char buf[BUFSIZ];
	FILE *fp = NULL;

	if (argc != 2)
		usage();

	/* Write all of the keys to a file */
	sprintf(tmpfile, "%s/gdbmsort.%d", getenv("TMPDIR") ?
	    getenv("TMPDIR") : "/tmp", getpid());
	if ((fp = fopen(tmpfile, "w+")) == NULL) {
		log_errno(tmpfile);
		exit(1);
	}
	mapfile = argv[1];
	mapdb = gdbm_open(mapfile, 0, GDBM_READER, 0644, NULL);
	if (mapdb == NULL) {
		errorlog("gdbm_open: %s: %s\n", mapfile,
		    gdbm_strerror(gdbm_errno));
		exit(1);
	}
	k = gdbm_firstkey(mapdb);
	while (k.dptr) {
		nextkey = gdbm_nextkey(mapdb, k);
		d = gdbm_fetch(mapdb, k);
		fwrite(k.dptr, 1, k.dsize - 1, fp);
		fputc('\n', fp);
		free(k.dptr);
		free(d.dptr);
		k = nextkey;
	}
	fclose(fp);

	/* Sort the keys */
	sprintf(buf, "sort < %s > %s.sorted", tmpfile, tmpfile);
	system(buf);
	(void) unlink(tmpfile);	/* remove old file */
	strcat(tmpfile, ".sorted");

	/* Read the keys again, and print data items */
	if ((fp = fopen(tmpfile, "r")) == NULL) {
		log_errno(tmpfile);
		gdbm_close(mapdb);
		exit(1);
	}
	while (fgets(buf, BUFSIZ, fp) != NULL) {
		*strchr(buf, '\n') = '\0';
		k.dptr = strdup(buf);
		k.dsize = strlen(k.dptr) + 1;
		d = gdbm_fetch(mapdb, k);
		fwrite(d.dptr, 1, d.dsize, stdout);
		fputc('\n', stdout);
		free(k.dptr);
		free(d.dptr);
	}
	fclose(fp);
	(void) unlink(tmpfile);
	gdbm_close(mapdb);
	exit(0);
}
