static char rcsid[] = "gdbmconsolidate.c,v 1.15 1996/01/04 03:46:46 duane Exp";
/*
 *  gdbmconsolidate - Builds a single database for multiple databases
 *
 *  Darren Hardy, hardy@cs.colorado.edu, May 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <gdbm.h>
#include "util.h"

static int d_flag = 0;
static int D_flag = 0;

extern int usage();

static void add_db(newdbf, filename)
     GDBM_FILE newdbf;
     char *filename;
{
	GDBM_FILE dbf;
	datum k, nextkey, d;

	dbf = gdbm_open(filename, 0, D_flag ? GDBM_WRITER : GDBM_READER,
	    0644, NULL);
	if (dbf == NULL) {
		errorlog("gdbm_open: %s: %s\n", filename,
		    gdbm_strerror(gdbm_errno));
		log_errno(filename);
		return;
	}
	k = gdbm_firstkey(dbf);
	while (k.dptr) {
		d = gdbm_fetch(dbf, k);
		gdbm_store(newdbf, k, d, GDBM_INSERT);
		free(d.dptr);
		nextkey = gdbm_nextkey(dbf, k);
		if (D_flag) {
			gdbm_delete(dbf, k);
		}
		free(k.dptr);
		k = nextkey;
	}
	gdbm_close(dbf);
	if (d_flag || D_flag)
		unlink(filename);
}

int do_consolidate(argc, argv)
     int argc;
     char *argv[];
{
	char *dbfile = NULL;
	GDBM_FILE dbf;

	if (argc < 3)
		usage();
	argc--;
	argv++;

	if (!strcmp(*argv, "-d")) {
		argv++;
		argc--;
		d_flag = 1;
	}
	if (!strcmp(*argv, "-D")) {
		argv++;
		argc--;
		D_flag = 1;
	}
	dbfile = strdup(*argv++);
	dbf = gdbm_open(dbfile, 0, GDBM_NEWDB | GDBM_FAST, 0644, NULL);
	if (dbf == NULL) {
		errorlog("gdbm_open: %s: %s\n", dbfile,
		    gdbm_strerror(gdbm_errno));
		log_errno(dbfile);
		exit(1);
	}
	while (--argc > 0) {
		printf("Adding %s to master database: %s\n", *argv, dbfile);
		fflush(stdout);
		add_db(dbf, strdup(*argv++));
	}
	gdbm_close(dbf);
	exit(0);
}
