static char rcsid[] = "harvest.c,v 1.15 1996/01/05 20:28:32 duane Exp";
/*
 *  harvest.c - Routines specific to the Harvest installation
 * 
 *  DEBUG: section  83, level 1         Common utilities pathname routines
 *
 *  Darren Hardy, hardy@cs.colorado.edu, December 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/param.h>
#include "util.h"

#define DEFAULT_HARVEST_HOME "/usr/local/harvest"

/*
 *  harvest_bindir() - Returns a static buffer that contains the 
 *  pathname that contains the binaries for Harvest.
 */
char *harvest_bindir()
{
    static char bindir[MAXPATHLEN + 1];
    char *s = NULL;

    if ((s = getenv("HARVEST_HOME")) != NULL)
	sprintf(bindir, "%s/bin", s);
    else
	sprintf(bindir, "%s/bin", DEFAULT_HARVEST_HOME);
    return (bindir);
}

/*
 *  harvest_libdir() - Returns a static buffer that contains the 
 *  pathname that contains the libraries for Harvest.
 */
char *harvest_libdir()
{
    static char libdir[MAXPATHLEN + 1];
    char *s = NULL;

    if ((s = getenv("HARVEST_HOME")) != NULL)
	sprintf(libdir, "%s/lib", s);
    else
	sprintf(libdir, "%s/lib", DEFAULT_HARVEST_HOME);
    return (libdir);
}

/*
 *  harvest_topdir() - Returns a static buffer that contains the 
 *  pathname that contains the libraries for Harvest.
 */
char *harvest_topdir()
{
    static char topdir[MAXPATHLEN + 1];
    char *s = NULL;

    if ((s = getenv("HARVEST_HOME")) != NULL)
	sprintf(topdir, "%s", s);
    else
	sprintf(topdir, "%s", DEFAULT_HARVEST_HOME);
    return (topdir);
}

/*
 *  add_harvest_to_path() - If xtra is not-NULL, then it will
 *  add harvest_libdir() + xtra to the path as well.  For example,
 *  a Gatherer process would call:
 *              add_harvest_to_path("gatherer:")
 *  to add $harvest_libdir/ and $harvest_libdir/gatherer
 */
void harvest_add_path(xtra)
     char *xtra;
{
    char *s = getenv("PATH");
    char *newpath = NULL;
    char *q = NULL;
    char *tmpxtra = NULL;

    if (s == NULL)
	fatal("This process does not have a PATH environment variable");
    newpath = xmalloc(strlen(s) + BUFSIZ);
    sprintf(newpath, "PATH=%s", s);
    sprintf(newpath + strlen(newpath), ":%s", harvest_bindir());
    if (xtra != NULL) {
	tmpxtra = xstrdup(xtra);
	q = strtok(tmpxtra, ":");
	while (q != NULL) {
	    sprintf(newpath + strlen(newpath), ":%s/%s",
		harvest_libdir(), q);
	    q = strtok(NULL, ":");
	}
	xfree(tmpxtra);
    }
    Debug(82, 1, ("Adding new PATH to environment: %s\n", newpath));
    (void) putenv(newpath);
}
