static char rcsid[] = "ccache_error.c,v 1.9 1995/09/05 19:09:50 hardy Exp";
/*
 *  error.c - Error handling routines for the ccache
 *
 *  David Merkel & Mark Peterson, University of Colorado - Boulder, July 1994  
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "ccache.h"

static CacheErr theErr = noErr;
static char FTPErr[3];

void DoError(CacheErr errType, char *errorReply)
{
	char locErr[4];
	u_long replyErr;

	if (errorReply != NULL) {
		memcpy(FTPErr, errorReply, SERV_REPLY_LENGTH);
		strncpy(locErr, errorReply, 3);
		locErr[3] = '\0';
		replyErr = htonl(*(u_long *) locErr);
	} else
		replyErr = 0;

	if (errType == SERV_REPLY_ERROR) {

		switch (replyErr) {
		case (SERV_NOT_RDY):
			theErr = srvNotRdy;
			break;
		case (NEED_ACCOUNT):
			theErr = needAccnt;
			break;
		case (SERV_NOT_AVAIL):
			theErr = srvNotAvl;
			break;
		case (SYNTAX_ERR):
			theErr = syntaxErr;
			break;
		case (CMD_NOT_IMPL):
			theErr = cmdNotImp;
			break;
		case (BAD_CMD_SEQ):
			theErr = badCmdSeq;
			break;
		case (CMD_UNIMP_PARM):
			theErr = cmdNImpParam;
			break;
		case (NOT_LOGD_IN):
			theErr = notLogdIn;
			break;
		case (FILE_NOT_FOUND):
			theErr = fileNotFound;
			break;
		default:
			break;
		}
		return;
	}
	switch (errType) {
	case (NO_ERROR):
		theErr = noErr;
		break;
	case (INIT_SOCKET_ERR):
		theErr = initSockErr;
		break;
	case (READ_FROM_SOCK_ERR):
		theErr = readSockErr;
		break;
	case (GET_SOCKET_ERR):
		theErr = getSockErr;
		break;
	case (GETHOST_ERR):
		theErr = getHostErr;
		break;
	case (CONNECT_ERR):
		theErr = connectErr;
		break;
	case (MEMORY_ERROR):
		theErr = memoryErr;
		break;
	case (WRITE_TO_SOCK_ERR):
		theErr = writeSockErr;
		break;
	case (SET_SOCKOPT_ERR):
		theErr = setSockOptErr;
		break;
	case (GET_HOSTNAME_ERR):
		theErr = getHNameErr;
		break;
	case (GET_HOSTBYNAME_ERR):
		theErr = getHBNameErr;
		break;
	case (GET_SOCKNAME_ERR):
		theErr = getSNameErr;
		break;
	case (BIND_ERR):
		theErr = bindErr;
		break;
	case (FILE_OPEN_ERR):
		theErr = fileOpenErr;
		break;
	case (WRITE_FILE_ERR):
		theErr = writeFileErr;
		break;
	case (CANT_GET_TMPNAME):
		theErr = tmpNameErr;
		break;
	case (ACCEPT_TIMEOUT_ERR):
		theErr = acceptTOut;
		break;
	case (READ_TIMEOUT_ERR):
		theErr = readTOut;
		break;
	case (ARGUMENT_INVALID):
		theErr = argInvalid;
		break;
	case (NO_REPLY_PRESENT):
		theErr = noReply;
		break;
	case (BAD_PARAM_ERR):
		theErr = badParam;
		break;
	case (URL_ERR):
		theErr = urlErr;
		break;
	case (BAD_URL_TYPE):
		theErr = badurlType;
		break;
	default:
		break;
	}
}

CacheErr GetError()
{
	return (theErr);
}

char *GetFTPError()
{
	static char *buffer;

	if ((buffer = (char *) malloc(SERV_REPLY_LENGTH + 1)) == NULL)
		return (NULL);
	memcpy(buffer, FTPErr, SERV_REPLY_LENGTH);
	buffer[SERV_REPLY_LENGTH] = '\0';
	return (buffer);
}
