static char rcsid[] = "select_loop.c,v 1.25 1995/09/15 05:54:41 duane Exp";
/*
 *  select_loop.c - Input socket processing for the Broker
 *
 *  DEBUG: section  78, level 9		Broker select(2) loop
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include "broker.h"
#include "log.h"
#ifdef _HARVEST_AIX_
#include <sys/select.h>
#else
int select();
#endif

/* Global variables */
extern int qsock;
extern int ndenied_connections;

/* Local variables */
int broker_offline = 0;
static char *busymsg = "103 - This Broker is currently undergoing maintenance.  Please try again later.\n";
static char *offlinemsg = "103 - This Broker will not process user or bulk queries.\n";

/* select_loop:                                                         */
/*                                                                      */
/*   listen on 'qsock' for an incoming connection.                      */
/*   return value is the same as select(2)'s return code, except on     */
/*   EINTR condition                                                    */
int select_loop(sec, usec, Accept)
int sec;
int usec;
int Accept;			/* accept new connections ? */
{
	struct timeval to;
	fd_set qready;
	int err, clen, msock;
	struct sockaddr_in cin;
	Host *H = NULL;

	if (qsock < 0)		/* we may call this before qsock is init */
		return 0;
	to.tv_sec = sec;
	to.tv_usec = usec;

	FD_ZERO(&qready);
	FD_SET(qsock, &qready);
	Debug(78,9,("select for %d.%06d seconds\n", to.tv_sec, to.tv_usec));
	err = select(qsock + 1, &qready, NULL, NULL, &to);
	Debug(78,9,("select returned: %d\n", err));
	if (err < 0) {
		if (errno == EINTR)
			return 0;
		log_errno("select");
		return -1;
	}
	if (err == 0)
		return 0;

	/* There's someone waiting to get it, let them through */
	if (FD_ISSET(qsock, &qready)) {
		clen = sizeof(cin);
		memset((char *) &cin, '\0', clen);
		msock = accept(qsock, (struct sockaddr *) &cin, &clen);
		if (msock < 0) {
			log_errno("accept");
			return -1;
		}
		if (H = get_host(inet_ntoa(cin.sin_addr))) {
			LOGCONNECT(H->fqdn);
		} else {
			LOGCONNECT(inet_ntoa(cin.sin_addr));
		}
		setsocket_linger(msock, 30);	/* 30 sec linger time */

		/* Immediately send the protocol version */
		if (write(msock, QMVERSION, strlen(QMVERSION)) < 0) {
			log_errno("initial socket write");
			(void)close(msock);
			return err;
		}

		/* Do the appropriate action with the incoming req */
		if (broker_offline) {
			(void)write(msock, offlinemsg, strlen(offlinemsg));
			(void)close(msock);
		} else if (Accept) {
			if (EV_add_sevent(msock) == ERROR) {
				(void)close(msock);
				ndenied_connections++;
			}
			/* msock lives on... */
		} else {
			(void)write(msock, busymsg, strlen(busymsg));
			(void)close(msock);
			ndenied_connections++;
		}
	}
	return err;	/* should be == 1 */
}
