%{
static char rcsid[] = "query.l,v 1.25 1995/09/20 20:33:11 duane Exp";
/* 
 *  query.l - Broker query manager interface lexical analyzer (lex/flex).
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include "broker.h"
#include "y.tab.h"

/* We need to input from a buffer */
#ifdef FLEX_SCANNER	/* flex does things differently */
#undef YY_INPUT
#define YY_INPUT(b, r, ms) (r = my_yyinput(b, ms))
#else			/* do a standard lex */
#undef input
#undef unput
#define input() 	my_input()
#define unput(c) 	my_unput(c)
#endif	/* FLEX_SCANNER */
#undef yywrap

/* Global variables */
extern int QM_gotphrase;

char *id_buf;		/* to pass ID's to the grammer parser */
char *input_buffer;	/* input buffer from query manager */
int input_bufsz;	/* size of the query string */
int input_bufferp;	/* current location in the input buffer */

%}

Letter          [A-Za-z]
Digit           [0-9]
Alphanum        [A-Za-z0-9_\/\-\\\200-\377]

%%

#BULK                                   {return(BULK_);}
#USER                                   {return(USERQ_);}
#ADMIN                                  {return(ADMIN_);}
#[Aa][Tt][Tt][Rr][Ii][Bb][Uu][Tt][Ee]	{return(ATTRIBUTE_);}
#[Oo][Pp][Ee][Rr][Aa][Tt][Ii][Oo][Nn]   {return(OPERATION_);}
#[Ii][Nn][Dd][Ee][Xx]			{return(INDEXFLAG_);}
#[Oo][Pp][Aa][Qq][Uu][Ee]		{return(OPAQUEFLAG_);}
#[Dd][Ee][Ss][Cc]			{return(DESCFLAG_);}
#[Aa][Ll][Ll][Bb]                       {return(ALLB_);}
#[Ee][Nn][Dd]                           {return(END_);}
#[Ss][Ii][Nn][Cc][Ee]                   {return(SINCETOK_);}
[Aa][Nn][Dd]	                        {return(AND_);}
[Oo][Rr]	                        {return(OR_);}
[Nn][Oo][Tt]	                        {return(NOT_);}
[Ee][Xx][Cc][Ee][Pp][Tt]                {return(EXCEPT_);}
#[Ss][Ee][Tt]                           {return(SET_);}
#[Cc][Oo][Mm][Pp][Rr][Ee][Ss][Ss]       {return(COMPRESS_);}
#[Uu][Nn][Ii][Qq][Ii][Ff][Yy]           {return(UNIQIFY_);}
#[Rr][Ee][Ss][Tt][Aa][Rr][Tt]-[Ii][Nn][Dd][Ee][Xx]-[Ss][Ee][Rr][Vv][Ee][Rr] {return (RESTIDXSVR_); }
#[Aa][Dd][Dd]-[Ll][Oo][Gg]              {return(LOGA_);}
#[Rr][Ee][Mm]-[Ll][Oo][Gg]              {return(LOGR_);}
#[Aa][Dd][Dd]-[Oo][Bb][Jj][Ee][Cc][Tt]                          {return(ADDO_);}
#[Rr][Ee][Mm]-[Oo][Bb][Jj][Ee][Cc][Tt]-[Pp][Aa][Tt][Hh]         {return(REMON_);}
#[Rr][Ee][Mm]-[Oo][Bb][Jj][Ee][Cc][Tt]-[Qq][Uu][Ee][Rr][Yy]     {return(REMOQ_);}
#[Cc][Oo][Ll][Ll][Ee][Cc][Tt][Ii][Oo][Nn]                       {return(COLLECT_);}
#[Cc][Ll][Ee][Aa][Nn]-[Bb][Rr][Oo][Kk][Ee][Rr]                  {return(CLEAN_);}
#[Ff][Uu][Ll][Ll]-[Ii][Nn][Dd][Ee][Xx]                          {return(FINDEX_);}
#[Ii][Nn][Cc][Rr][Ee][Mm][Ee][Nn][Tt][Aa][Ll]-[Ii][Nn][Dd][Ee][Xx] {return(IINDEX_);}
#[Ff][Ll][Uu][Ss][Hh]-[Ll][Oo][Gg]                      {return(LFLUSH_);}
#[Cc][Ll][Oo][Ss][Ee]-[Ll][Oo][Gg]                      {return(LCLOSE_);}
#[Oo][Pp][Ee][Nn]-[Ll][Oo][Gg]                          {return(LOPEN_);}
#[Rr][Oo][Tt][Aa][Tt][Ee]-[Ll][Oo][Gg]  		{return(LROTATE_);}
#[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd]                       {return(PASSWD_);}
#[Rr][Ee][Ss][Tt][Aa][Rr][Tt]                           {return(START_);}
#[Ss][Hh][Uu][Tt][Dd][Oo][Ww][Nn]                       {return(SHUTDN_);}
#[Dd][Oo]-[Ss][Tt][Aa][Tt][Ss]				{return(DOSTATS_);}
#[[Ii][Nn][Ff][Oo]					{return(INFO_);}
#[[Pp][Ii][Nn][Gg]					{return(PING_);}
"("	                 {return(LPAREN_);}
")"	                 {return(RPAREN_);}
"{"	                 {return(LCBRACK_);}
"}"	                 {return(RCBRACK_);}
"="	                 {return(EXACT_);}
":"	                 {return(REGEXP_);}
"<"	                 {return(LSST_);}
">"	                 {return(GTRT_);}
","                      {return(COMMA_);}
{Alphanum}+              {id_buf = strdup(yytext); return(ID_);}
\"([^;'"])+\"            {id_buf = strdup(yytext+1); id_buf[strlen(id_buf)-1] = '\0'; QM_gotphrase = 1; return(ID_);}
.                        {}

%%

/* 
 *  All of this garbage below is to manager FILE vs. in-memory buffer
 *  input and the differences between Lex and GNU Flex.
 */

#ifdef FLEX_SCANNER
int my_yyinput(buf, max_size)
char *buf;
int max_size;
{
	int n = max_size < input_bufsz - input_bufferp ? max_size :
		input_bufsz - input_bufferp;

	if (n > 0) {
		memcpy(buf, &input_buffer[input_bufferp], n);
		input_bufferp += n;
	}
	return(n);
}
#else	/* standard lex */
int my_input()
{
	if (input_bufferp < input_bufsz)
		return(input_buffer[input_bufferp++]);
	return(0);
}

int my_unput(c)
int c;
{
	if (input_bufferp != 0)
		input_buffer[--input_bufferp] = c;
	return c;
}

int yyrestart(fp)
FILE *fp;
{
}
#endif	/* FLEX_SCANNER */

int yywrap()
{
	return 1;
}
