static char rcsid[] = "brkutil.c,v 1.27 1995/09/05 18:25:32 hardy Exp";
/*
 * brkutil.c -- Broker utility functions
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include "broker.h"

/* Global Variables */
extern char *DIRpath;
extern time_t Cur_Time;

char *UTIL_make_admin_filename(name)
char *name;
{
	static char *filename;

	filename = (char *) xmalloc(MAX_FN_SIZE + 1);
	sprintf(filename, "%s/admin/%s", DIRpath, name);

	return (filename);
}

/* get time with error checking */
time_t UTIL_Get_Time()
{
	time_t now;

	now = time(NULL);
	if (now == -1) {
		errorlog("%s%s\n", COLLECT, TIME_ERR);
		now = 0;
	} else {
		Cur_Time = now;
	}

	return (now);
}

/* change the given string to lower case */
int UTIL_Make_Lower(name)
char *name;
{
	char *s = name;

	while (*s) {
		if (isupper((unsigned char) *s))	/* this is faster */
			*s = tolower((unsigned char) *s);
		s++;
	}
	return SUCCESS;
}


/* indexer routines */
extern struct indexing_routines *INDEXER;

int do_IND_Index_Start()
{
	return ((*INDEXER->IND_Index_Start) ());
}

int do_IND_Index_Flush()
{
	return ((*INDEXER->IND_Index_Flush) ());
}

int do_IND_New_Object(a)
reg_t *a;
{
	return ((*INDEXER->IND_New_Object) (a));
}

int do_IND_Destroy_Obj(a)
reg_t *a;
{
	return ((*INDEXER->IND_Destroy_Obj) (a));
}

int do_IND_Index_Full()
{
	return ((*INDEXER->IND_Index_Full) ());
}

int do_IND_Index_Incremental()
{
	return ((*INDEXER->IND_Index_Incremental) ());
}

int do_IND_initialize()
{
	return ((*INDEXER->IND_initialize) ());
}

int do_IND_config(a, b)
char *a, *b;
{
	return ((*INDEXER->IND_config) (a, b));
}

int do_IND_do_query(a, b, c, d)
qlist_t *a;
int b, c;
time_t d;
{
	return ((*INDEXER->IND_do_query) (a, b, c, d));
}

void do_IND_Init_Flags()
{
	(*INDEXER->IND_Init_Flags) ();
	return;
}

void do_IND_Set_Flags(a, b)
char *a, *b;
{
	(*INDEXER->IND_Set_Flags) (a, b);
	return;
}
