: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  
#
#  l2h.pl - simple LaTeX to HTML translator
#
#  Usage: l2h.pl < filename.tex > filename.html
#
#  l2h.pl,v 1.6 1995/09/05 20:17:52 hardy Exp
#
#  Duane Wessels & Darren Hardy, University of Colorado, March 1995
#
#######################################################################
#  Copyright (c) 1994, 1995.  All rights reserved.
#  
#    The Harvest software was developed by the Internet Research Task
#    Force Research Group on Resource Discovery (IRTF-RD):
#  
#          Mic Bowman of Transarc Corporation.
#          Peter Danzig of the University of Southern California.
#          Darren R. Hardy of the University of Colorado at Boulder.
#          Udi Manber of the University of Arizona.
#          Michael F. Schwartz of the University of Colorado at Boulder.
#          Duane Wessels of the University of Colorado at Boulder.
#  
#    This copyright notice applies to software in the Harvest
#    ``src/'' directory only.  Users should consult the individual
#    copyright notices in the ``components/'' subdirectories for
#    copyright information about other software bundled with the
#    Harvest source code distribution.
#  
#  TERMS OF USE
#    
#    The Harvest software may be used and re-distributed without
#    charge, provided that the software origin and research team are
#    cited in any use of the system.  Most commonly this is
#    accomplished by including a link to the Harvest Home Page
#    (http://harvest.cs.colorado.edu/) from the query page of any
#    Broker you deploy, as well as in the query result pages.  These
#    links are generated automatically by the standard Broker
#    software distribution.
#    
#    The Harvest software is provided ``as is'', without express or
#    implied warranty, and with no support nor obligation to assist
#    in its use, correction, modification or enhancement.  We assume
#    no liability with respect to the infringement of copyrights,
#    trade secrets, or any patents, and are not responsible for
#    consequential damages.  Proper use of the Harvest software is
#    entirely the responsibility of the user.
#  
#  DERIVATIVE WORKS
#  
#    Users may make derivative works from the Harvest software, subject 
#    to the following constraints:
#  
#      - You must include the above copyright notice and these 
#        accompanying paragraphs in all forms of derivative works, 
#        and any documentation and other materials related to such 
#        distribution and use acknowledge that the software was 
#        developed at the above institutions.
#  
#      - You must notify IRTF-RD regarding your distribution of 
#        the derivative work.
#  
#      - You must clearly notify users that your are distributing 
#        a modified version and not the original Harvest software.
#  
#      - Any derivative product is also subject to these copyright 
#        and use restrictions.
#  
#    Note that the Harvest software is NOT in the public domain.  We
#    retain copyright, as specified above.
#  
#  HISTORY OF FREE SOFTWARE STATUS
#  
#    Originally we required sites to license the software in cases
#    where they were going to build commercial products/services
#    around Harvest.  In June 1995 we changed this policy.  We now
#    allow people to use the core Harvest software (the code found in
#    the Harvest ``src/'' directory) for free.  We made this change
#    in the interest of encouraging the widest possible deployment of
#    the technology.  The Harvest software is really a reference
#    implementation of a set of protocols and formats, some of which
#    we intend to standardize.  We encourage commercial
#    re-implementations of code complying to this set of standards.  
#  
#  

# Note about multiline matching.   We originally used s///m in some places
# which is not supported in Perl4.  Now we surround those sections with
# $*=1 / $*=0 pairs.

$/ = "";		# paragraph at a time
$debug	= 0;

print "<HTML>\n";

while (<STDIN>) {
	print STDERR "DOING: '", $_, "'\n" if ($debug);

	s/\\\@//og;				# delete \@
	s/\\-//og;				# delete \-
	s/\\_/_/og;				# change \_ to _
	s/\\/\@/og;				# change \ to @ everywhere
	s/</\@lt/go;				# escape SGML brackets
	s/>/\@gt/go;

	$_ = "<P>\n" . $_ unless (/^\s*\@/o);	# Mark this as a <P> unless
						# the first line ends with
						# a backslash

	s/~/ /og;				# sticky spaces

	s/\(/\@lparen/og;			# protect
	s/\)/\@rparen/go;
	s/\[/\@lbrack/go;
	s/\]/\@rbrack/go;
	s/\*/\@asterisk/go;
	s/\@%/\@percent/og;
	s/\@\$/\@dollar/go;
	s/%/\@percent/og if (/\@begin{verbatim}/o);
	s/%/\@percent/og if (/\@end{verbatim}/o);

	# do all font/size changes *FIRST*
	$* = 0;
	1 while s/({\@bf\s*([^}]*)})/<STRONG>$2<\/STRONG>/o;
	1 while s/({\@em\s*([^}]*)})/<EM>$2<\/EM>/o;
	1 while s/({\@it\s*([^}]*)})/<EM>$2<\/EM>/o;
	1 while s/({\@tt\s*([^}]*)})/<CODE>$2<\/CODE>/o;
	1 while s/({\@sc\s*([^}]*)})/<CODE><STRONG>$2<\/STRONG><\/CODE>/o;
	1 while s/\@verb\+([^\+]*)\+/<CODE>$1<\/CODE>/o;
	$* = 0;

	s/%.*\n/\n/og;				# delete comments

	# delete some environments
	$* = 0;
	s/\@begin{latexonly}([\s\S]*)\@end{latexonly}//og;
	s/\@begin{htmlonly}([\s\S]*)\@end{htmlonly}//og;
	s/\@begin{figure}([\s\S]*)\@end{figure}//og;
	s/\@begin{tabular}([\s\S]*)\@end{tabular}//og;
	s/\@begin{tabbing}([\s\S]*)\@end{tabbing}//og;
	s/\@begin{comment}([\s\S]*)\@end{comment}//og;
	$* = 1;

	# delete some tags
	1 while s/(see\s*{([^}]*)})//o;		# do see{} before \index
	1 while s/(\@index\s*{([^}]*)})//o;
	1 while s/(\@input\s*{([^}]*)})//o;
	1 while s/(\@include\s*{([^}]*)})//o;
	1 while s/(\@pagenumbering\s*{([^}]*)})//o;
	1 while s/(\@bibliographystyle\s*{([^}]*)})//o;
	1 while s/(\@ref\s*{([^}]*)})//o;
	1 while s/(\@label\s*{([^}]*)})//o;
	1 while s/(\@cite\s*{([^}]*)})//o;
	$* = 1;
	1 while s/(\@footnote\s*{([^}]*)})//o;
	$* = 0;
	1 while s/(\@documentstyle\s*{([^}]*)})//o;
	1 while s/(\@documentclass\s*{([^}]*)})//o;
	1 while s/(\@documentstyle\@lbrack.*\@rbrack\s*{([^}]*)})//o;
	1 while s/(\@documentclass\@lbrack.*\@rbrack\s*{([^}]*)})//o;
	s/\@small//og;
	s/\@normalsize//og;
	s/\@footnotesize//og;
	s/\@large//og;
	s/\@Large//og;
	s/\@makeindex//og;
	s/\@maketitle//og;
	s/\@tableofcontents//og;
	s/\@null//og;

	# ignore some environments
	s/\@begin{document}//og;
	s/\@end{document}//og;
	s/\@begin{center}//og;
	s/\@end{center}//og;
	s/\@begin{titlepage}//og;
	s/\@end{titlepage}//og;
	s/\@begin{htmlonly}//og;
	s/\@end{htmlonly}//og;
	s/\@begin{latexonly}//og;
	s/\@end{latexonly}//og;
	s/\@begin{rawhtml}//og;
	s/\@end{rawhtml}//og;


	s/\@\@/<BR>/og;				# force line break
	s/\@newline/<BR>/og;


	# do section headers
	1 while s/(\@chapter(\@asterisk|\s*){([^}]*)})/<H1>$3<\/H1>/o;
	1 while s/(\@shortchapter(\@asterisk|\s*){([^}]*)})/<H1>$3<\/H1>/o;
	1 while s/(\@section(\@asterisk|\s*){([^}]*)})/<H2>$3<\/H2>/o;
	1 while s/(\@subsection(\@asterisk|\s*){([^}]*)})/<H3>$3<\/H3>/o;
	1 while s/(\@subsubsection(\@asterisk|\s*){([^}]*)})/<H4>$3<\/H4>/o;
	1 while s/(\@paragraph(\@asterisk|\s*){([^}]*)})/<H5>$3<\/H5>/o;
	1 while s/(\@subparagraph(\@asterisk|\s*){([^}]*)})/<H6>$3<\/H6>/o;

	# translate \item[foo] into <LI><b>foo</b>
	s/\@item\@lbrack(.*)\@rbrack/<LI><STRONG>$1<\/STRONG>/og;
	s/\@item/<LI>/og;

	# do title/author
	1 while s/(\@title\s*{([^}]*)})/<TITLE>$2<\/TITLE>/o;
	1 while s/(\@author\s*{([^}]*)})/<ADDRESS>$2<\/ADDRESS>/o;

	# sub some tags
	s/\@newpage/<P>/og;
	$* = 1;
	s/\@htmladdnormallinkfoot{([^}]*)}\s*{([^}]*)}/<A HREF="$2">$1<\/A>/og;
	s/\@htmladdnormallink{([^}]*)}\s*{([^}]*)}/<A HREF="$2">$1<\/A>/og;
	$* = 0;

	# do binary pairs for environments
	s/\@begin{verbatim}/<PRE>/og;
	s/\@end{verbatim}/<\/PRE>/og;
	s/\@begin{enumerate}/<OL>/og;
	s/\@end{enumerate}/<\/OL>/og;
	s/\@begin{itemize}/<UL>/og;
	s/\@end{itemize}/<\/UL>/og;
	s/\@begin{description}/<UL>/og;
	s/\@end{description}/<\/UL>/og;
	s/\@begin{quote}/<BLOCKQUOTE>/og;
	s/\@end{quote}/<\/BLOCKQUOTE>/og;

	s/\@lparen/\(/og;				# un-protect
	s/\@rparen/\)/og;
	s/\@lbrack/\[/og;
	s/\@rbrack/\]/og;
	s/\@percent/%/og;
	s/\@asterisk/\*/og;
	s/\@dollar/\$/og;
	s/\@gt/\&gt;/go;
	s/\@lt/\&lt;/go;

	s/\$([^\$]*)\$/<EM>$1<\/EM>/go;		# maths into italics

	print STDERR $_ if ($debug);
	print if (/\S/o);			# print if data
}

print "</HTML>\n";
exit 0
