

/*
 * (c) Copyright 1993 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 *
 * with vi use :se ts=3
 */

static char RCSid[] = "dit.c,v 1.5 1994/12/20 20:05:14 hardy Exp";

#include "string.h"

#include "sio.h"

#define PAGE_ID						"%%Page:"

#include "defs.h"

void decode_string();


PRIVATE void skip_to_first_page(fd)
int fd;
{
	char *line;
	char *page_id = PAGE_ID;
	int len = strlen(PAGE_ID);

	while (line = Srdline(fd)) {
		line_count++;
		if (strncmp(line, page_id, len) == 0)
			return;
	}
	error("Failed to find 1st page\n");
}


int get_line_char(sp)
char **sp;
{
	char *p = *sp;
	char c = *p++;

	if (c == NUL)
		error("Reached end of line while reading string\n");
	*sp = p;
	return (c);
}


/*
 * Assumptions:
 *              2 consecutive numbers ==> new line
 *              first char of each line is a number
 */
void psdit_process(fd)
int fd;
{
	char *line;
	char *p;
	int output_string = FALSE;

	skip_to_first_page(fd);

	while (line = Srdline(fd)) {
		if (isdigit(line[0])) {
			for (p = &line[1]; isdigit(*p); p++);

			while (isspace(*p)) p++;

			if (isdigit(*p)) {
				for (p++; isdigit(*p); p++);
				if (output_string) {
					printout(NEWLINE);
					output_string = FALSE;
				}
			}
		}
		else {
		   extern int used;	/* buffer pointer from printout routine */
			if (used && strchr(line, '('))
				used--; /*
                     * remove mid-word space, as in the following:
								1611 1753(W)N
								(ide)S
								1894(Area)X
                     */
			p = line;
		}

		p = strchr(p, OPEN_PAREN);
		if (p == NULL)
			continue;
		p++;
		decode_string(get_line_char, (void *)&p);
		output_string = TRUE;
		if (isalpha(*p))
			printout(SPACE);
	}
}


void ditroff_process(fd)
int fd;
{
	char *line;
	char *page_id = PAGE_ID;
	int len = strlen(PAGE_ID);

	skip_to_first_page(fd);

	while (line = Srdline(fd)) {
		char *p;

		if (line[0] == '%') {
			if (strncmp(page_id, line, len) == 0)
				start_paragraph();
			continue;
		}
		p = strchr(line, OPEN_PAREN);
		if (p == NULL)
			continue;
		if (p[-1] == 'Y')
			printout(NEWLINE);
		else if (p[-1] == 'Z')
			start_paragraph();
		p++;
		decode_string(get_line_char, (void *) &p);
		printout(SPACE);
	}
}

void troff_process(fd)
int fd;
{
	char *line;
	int output_string = FALSE;

	skip_to_first_page(fd);

	while (line = Srdline(fd)) {
		char *p;

		if (line[0] == '%')
			continue;

		for (p = line; *p;) {
			if (*p == OPEN_PAREN) {
				p++;
				decode_string(get_line_char, (void *) &p);
				output_string = TRUE;
			} else if (isdigit(*p)) {
				while (isdigit(*p))
					p++;
				if (isspace(*p)) {
					while (isspace(*p))
						p++;
					if (isdigit(*p)) {
						while (isdigit(*p))
							p++;
						if (output_string) {
							printout(NEWLINE);
							output_string = FALSE;
						}
					}
				}
			} else
				p++;
		}
	}
}
