#!/usr/local/bin/perl
###
### gillot@suncms10.cern.ch (Jean Francois Gillot) 
### 
### Line mode browser
### 
### CERN European Lab for Particle Physics Tue, 17 Oct 1995 08:40:36 GMT 
### 
### Newsgroups: 
###    comp.infosystems.harvest 
### 
### 
### 
### Hi all, 
### 
### Harvest makes a good job and is useful. But what happens when you have
### people with only line mode browser wanting to query your broker? Or if
### people with no form capable browser want it?
###
### So follows a scritp for that case, using only an ISINDEX field, that
### every browser (even the smallest) implements. It nust be called with a
### no form query
###
### Comments welcomed.
###
### ................ noform.pl................................

$|=1;
$debug=0;

local(@keywords);
local($query);

if ($ENV{'CONTENT_LENGTH'}) {
        read(STDIN,$query,$ENV{'CONTENT_LENGTH'});
} else {
        if ($ENV{'QUERY_STRING'}) {
                $query=$ENV{'QUERY_STRING'};
        }
}

if ( length($query) ) {
        @keywords=split(/ /,&unescape($query));
} else{
        print <<EOFM;
Content-Type: text/html




Query Interface to the cmsdoc Broker

You may access some statistics about this Broker.

Enter your query in the box below and hit enter to send.  


This is a searchable index. Enter search keywords: 


Query Options:

  -i makes the query case sensitive
  -s makes Keywords matching not only on word boundaries
  -e1 or -e2 allows one or two spelling errors (default 0)
  -m234 limits the output of the search to 234 lines (default 50)
  -d makes the matched lines to be displayed in the query result.



Please send questions and comments to docmaster@cmsdoc.cern.ch 

EOFM
exit 0;
}

local(%options)=(
        'query',                '',
        'brokerqueryconfig',    'CMSdocPrinting.cf',
        'broker',               'cmsdoc',
        'caseflag',             'on',
        'wordflag',             'on',
        'errorflag',            '0',
        'opaqueflag',           'off',
        'descflag',             'on',
        'maxresult',            'off'
        );

local(@keywords2);

while (@keywords) {
        $word=&unescape(pop(@keywords));
        if ($word eq '-i'){
                $options{'caseflag'}='off';
        }
        if ($word eq '-jfg'){
                $debug=2;
        }
        if ($word eq '-s'){
                $options{'wordflag'}='off';
        }
        if ($word eq '-d'){
                $options{'opaqueflag'}='on';
        }
        if ($word =~ /^-e/){
                $options{'errorflag'}=chop($word);
                $options{'errorflag'}=2 if ($options{'errorflag'} > 2);
        }
        if ($word =~ /^-m/){
                $options{'maxresult'}=substr($word,2);
        }
        if ($word !~ /^-/){
                $options{'query'} .= $word . " ";
        }
        push(@keywords2,$word);
}

if ($debug>1) {
        print "Content-type: text/html\n\n";
}

if ($debug) {
        print "\n";
        print 'Keywords tab
';
        print '
 ';
         while (@keywords2){
                 print '
 ' . pop(@keywords2);
         }
         print '
';
        print "Options tab
";
        &dump_array(%options);
}



#
# Construction of the command line
#
local($key);
foreach $key (sort keys(%options)) {
        print $key . "
\n" if ($debug);
        if ($options{$key} ne 'off') {
                $command .=  $key . '=' . $options{$key} . '&';
        }
}
chop($command);
$command =~ tr/ /+/;
print $command . "
\n" if ($debug);

print "Location: /Harvest/cgi-bin/BrokerQuery.pl.cgi?$command\n\n" unless ($debug);

exit 0;

sub dump_array {
        local (%A) =  @_;
        local ($key);
        print "
 \n";
         #foreach $key ( sort keys(%A)) {
         foreach $key (sort keys(%A)){
                 print "
  $key = $A{$key}\n";
         }
         print "
\n";
}

sub unescape {
        local($todecode)=@_;
        $todecode =~ tr/+/ /;
        $todecode =~ s/%([0-9A-Ha-h]{2})/pack("c",hex($1))/ge;
        return($todecode);
}
 
sub parse_keywordlist {
        local($tosplit) = @_;
        $tosplit = &unescape($tosplit);
        $tosplit =~ tr/+/ /;
        local(@keywords) = split(/\s+/,$tosplit);
        return(@keywords);
}
