#!/bin/sh

# 'SimpleBrokerQuery.sh':  A wrapper for BrokerQuery.pl.  Designed to 
# allow simple Harvest searches without the full query/form interface.
#
# Sample form for this script:
#
# <FORM METHOD="GET" ACTION="http://morse.Colorado.EDU/bin/SimpleBrokerQuery">
# <b>Look for:</b> <INPUT NAME="query" TYPE="text" SIZE="40">
# <INPUT TYPE="submit" VALUE="Submit">
# <INPUT TYPE="reset" VALUE="Reset">
# </FORM>
#
# all other form options from the real query.html are faked here by 
# appending to the passed in $QUERY_STRING.

# CHANGE THESE VALUES
broker_host=YourHost			# hostname were broker is running
broker_port=8501			# port where broker is running

# Defaults from glimpse-query.html
#
caseflag="on"				# ignore case
wordflag="on"				# match word boundaries
errorflag="0"				# spelling errors
opaqueflag="on"				# return opaque data
descflag="on"				# print description lines
verbose="on"				# be verbose
maxresult="50"				# max # hits to return


# 'SimpleBrokerQuery' and 'BrokerQuery.pl' must be in the same directory.
dir=`dirname $0`

QUERY_STRING="${QUERY_STRING}&caseflag=${caseflag}&wordflag=${wordflag}&errorflag=${errorflag}&opaqueflag=${opaqueflag}&descflag=${descflag}&verbose=${verbose}&maxresultflag=${maxresult}&host=${broker_host}%3A${broker_port}"
export QUERY_STRING

exec $dir/BrokerQuery.pl.cgi
