static char rcsid[] = "RegisterURL.c,v 1.6 1995/09/05 19:07:43 hardy Exp";
/*
 *  RegisterURL.c - CGI Forms interface using POST for users to register
 *  their URL with one of the Gatherers.
 *
 *  Look at 
 *  http://harvest.cs.colorado.edu/Harvest/brokers/register-with-CU-brokers.html
 *  for an example HTML page to go with this program.
 *
 *  Darren Hardy, University of Colorado - Boulder, November 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "util.h"
#include "template.h"

/*
 *  LOG_DIRECTORY is the dir into which the registered URLs will be written.
 */
#ifndef LOG_DIRECTORY
#define LOG_DIRECTORY	"/usr/local/etc/httpd/logs/broker-urls"
#endif

#define MAX_ENTRIES 256

typedef struct {
	char *name;
	char *val;
} entry;

/* External functions from util.c */
extern char *makeword();
extern char *fmakeword();
extern char x2c();
extern void unescape_url();
extern void plustospace();

/* Local functions */
static char *get_time();
static void cgi_fatal();

static char *urls = NULL, *broker = NULL;

int main(argc, argv)
int argc;
char *argv[];
{
	Template *t;
	entry entries[MAX_ENTRIES];
	char buf[BUFSIZ];
	int x, m = 0, cl;
	FILE *fp;

	urls = broker = NULL;

	printf("Content-type: text/html\n\n");

	if (strcmp(getenv("REQUEST_METHOD"), "POST")) {
		cgi_fatal("This script must use POST.");
	}
	if (strcmp(getenv("CONTENT_TYPE"), "application/x-www-form-urlencoded")) {
		cgi_fatal("This script can only be used to decode form results.\n");
	}
	cl = atoi(getenv("CONTENT_LENGTH"));

	for (x = 0; cl && (!feof(stdin)); x++) {
		m = x;
		entries[x].val = fmakeword(stdin, '&', &cl);
		plustospace(entries[x].val);
		unescape_url(entries[x].val);
		entries[x].name = makeword(entries[x].val, '=');
	}

	printf("<title>Results of registering your URLs</title>\n");
	printf("<h1>Results of registering your URLs</h1>\n");
	printf("<p><hr><p>\n");

	for (x = 0; x <= m; x++) {
		if (!strcmp(entries[x].name, "urls")) {
			urls = strdup(entries[x].val);
			if (strlen(urls) < 1)
				urls = NULL;
		} else if (!strcmp(entries[x].name, "which-broker")) {
			broker = strdup(entries[x].val);
			if (strlen(broker) < 1)
				broker = NULL;
		}
	}

	if (urls == NULL)
		cgi_fatal("Must enter URLs.\n");
	if (broker == NULL)
		cgi_fatal("Must specify a Broker.\n");

	sprintf(buf, "%s/%s", LOG_DIRECTORY, broker);
	if ((fp = fopen(buf, "a")) == NULL) {
		cgi_fatal("Internal error while registering. Sorry.\n");
	}
	fprintf(fp, "%s\n", urls);
	fclose(fp);

	printf("Successfully registered the URLs.\n");
	printf("The URLs will be included in the Broker soon.\n");
	printf("Thanks.\n");
	exit(0);
}

/*
 *  cgi_fatal() - Print error message to user via stdout; and nicely log
 *  the error to stderr where httpd will save it in error_log.
 */
static void cgi_fatal(s)
char *s;
{
	fprintf(stdout, "%s\n", s);
	fprintf(stderr, "[%s] BrokerQuery: %s", get_time(), s);
	fflush(stdout);
	fflush(stderr);
	exit(1);
}

/* get_time from NCSA httpd */
static char *get_time()
{
	time_t t;
	char *time_string;

	t = time(NULL);
	time_string = ctime(&t);
	time_string[strlen(time_string) - 1] = '\0';
	return (time_string);
}
