#include <stdio.h>

#include "mst.h"

#define newdistance(x, y) (newdistances[(x)*nodes+(y)])
#define connection(x, y)  (connections[(x)*nodes+(y)])

typedef struct {
  int node;                              /* node id */
  double cost;                           /* cost estimation to this node */
} cost_struct;

static cost_struct *Q;                   /* cost priority queue */
static char *S;                          /* Is a node in the priority queue? */
static int qsize;                        /* cost priority queue size */

#define Parent(x)     (((x)-1)/2)
#define Left(x)       ((x)*2+1)
#define Right(x)      ((x)*2+2)
#define swap(x,y,t)   ((t)=(x), (x)=(y), (y)=(t))
#define EVER          (;;)

#ifdef NEVER

heapify(i)
int i;
{
  cost_struct tmp;
  register l, r, least;

  for EVER {
    l = Left(i);
    r = Right(i);
    least = ((Q[l].cost < Q[i].cost) && (l < qsize)) ? l : i;
    if ((Q[r].cost < Q[least].cost) && (r < qsize)) least = r;
    if (least != i) {
      swap(Q[i], Q[least], tmp);
      i = least;
    }
    else return;
  }
}
dec_key(i, cost)
int i;
double cost;
{
  register ti;
  cost_struct tc;

  Q[i].cost = cost;
  while (i>0 && Q[Parent(i)].cost > cost) {
      swap(Q[i], Q[Parent(i)], tc);
      i = Parent(i);
  }
}
#endif


cost_struct 
extract_min()
{
  cost_struct min;

  min = Q[0];
  S[min.node] = 1;
  Q[0] = Q[--qsize];
  heapify(0);
  return min;
}
/*
 *  Compute shortest path from node s to all other nodes.
 *  Return the distance of longest path.
 */
double dijkstra(s, connections, newvdistance)
int s;
Imatrix connections;
Fvector newvdistance;
{
  int i, n;
  cost_struct u;
  double cost, c;

  qsize = nodes;
  S = (char *)calloc(qsize, sizeof(char));
  Q = (cost_struct *)malloc(qsize*sizeof(cost_struct));
  for (i=0; i<nodes; i++) {
    Q[i].node = i;
    Q[i].cost = Inf;
  }
  Q[0].cost = 0;
  Q[0].node = s;
  Q[s].node = 0;

  while (qsize > 1) {
    u = extract_min();
    for (i=0; i<qsize; i++)
      if (connection(u.node, Q[i].node)) {
	/* relax(u, v) */
	n = Q[i].node; c = Q[i].cost;
	if (c > (cost = u.cost + distances[u.node][n])) dec_key(i, c = cost);
	if (newvdistance != NULL) newvdistance[n] = c;
      }
  }
  cost = Q->cost;
  if (newvdistance != NULL) newvdistance[Q->node] = cost;
  free(Q); free(S);
  return cost;
}

double diameter()
{
  int i;
  double d, dist;

  for (d=i=0; i<nodes; i++)
    if (d < (dist = dijkstra(i, connects, NULL))) d = dist;
  return d;
}

double shortest(olddistances)
Fmatrix *olddistances;
{
  int i;
  double d, dist;
  Fmatrix newdistances;

  newdistances = (Fmatrix) malloc (nodes * nodes * sizeof (double));
  for (d=i=0; i<nodes; i++)
    if (d < (dist = dijkstra(i, distances, newdistances + i*nodes))) d = dist;
  free (*olddistances);
  *olddistances = newdistances;
  return d;
}

double totalcost()
{
  int i, j;
  double total = 0;

  for (i=0; i<nodes; i++)
    for (j=0; j<i; j++)
      total += distances[i][j];
  return total;
}

double linkcost()
{
  int i, j;
  double total = 0;

  for (i=0; i<nodes; i++)
    for (j=0; j<i; j++)
      if (connect(i, j)) total += distances[i][j];
  return total;
}
