#!/usr/bin/perl

require 'ftp.pl';
$configfile = $ARGV[1];
$configfile="./mirrord.conf" if (!$ARGV[1]);

$mirror_prog = "mirror";
$mirror_args = "-N";
$mirror_log = "/tmp/mirrord.log";
$mirror_config = "/tmp/mirror.config";
$local_user="dante";
$local_host="valhalla.datawave.net";



sub
update_from_spec
{
    local ($update_spec)     = @_;

    local ($remote_site)     = match_field ($update_spec, "<SITE>");
    local ($remote_file)     = match_field ($update_spec, "<VERSION-FILE>");
    local ($remote_user)     = match_field ($update_spec, "<USER>");
    local ($remote_password) = match_field ($update_spec, "<PASSWORD>");
    local ($remote_directory)= match_field ($update_spec, "<DIRECTORY>");

    local ($local_dir) = local_file_field ("<LOCAL-DIRECTORY>", $configfile);
    local ($local_version_file) = 
         local_file_field ("<VERSION-FILE>", $configfile);
    local ($local_version) = 
         local_file_field ("<VERSION>", $local_version_file);

    print "remote_site = $remote_site\n";
    print "remote_user = $remote_user\n";
    print "remote_password = $remote_password\n";
    print "remote_file = $remote_file\n";
    print "remote_directory = $remote_directory\n";
    $remote_password = "$local_user@$local_site";

    $remote_spec = get_remote_spec ($remote_site, 
				    $remote_user,
				    $remote_password,
				    $remote_file)  ||
					die ("Couldn\'t get remote version");

    $remote_version = match_field ($remote_spec, "<VERSION>");
    
    print "Remote version $remote_version, $local_version (local version)\n";
    if ($remote_version <= $local_version)
    {
       print "Remote version $remote_version <= $local_version (local version)\n";
	exit (0);
    }

    if ($remote_directory eq '')
    {
        die ("Remote directory $remote_directory invalid\n")
    }
    # Okey dokey, now fire up the mirror process
    # Find out where the local directory goes

    print "local_dir = $local_dir\n";

    $remote_config = match_field ($remote_spec, "<UPDATE-TEMPLATE>");

    if ($remote_config eq "")
    {
	die ("Could not get remote UPDATE-TEMPLATE\n");
    }

    open (CONFIG, "> $mirror_config") || die ("could not open config file \`$mirror_config\'");
    
    chmod 0600, $mirror_config;
    $remote_config = substitute_variables ($remote_config);
    print CONFIG $remote_config;
    close (CONFIG);

    unlink ($mirror_log);
    print "$mirror_prog $mirror_args $mirror_config > $mirror_log 2>&1 ";
    $ret_val = system ("$mirror_prog $mirror_args $mirror_config > $mirror_log 2>&1") >> 8;
    
    if ($ret_val != 0)
    {
	print "mirror failed\n";
    }
    else
    {
	# We need to update the VERSION file.
        print "VERSION-FILE: $local_version_file\n";

	open (VERSION, "> $local_version_file.$$\n") || die ("Could not create vaersion file $local_version_file.$$\n");

	print VERSION $remote_spec;
	unlink ("$local_version_file");
	rename ("$local_version_file.$$", "$local_version_file");
    }
#    unlink ($mirror_config);
}

sub
substitute_variables 
{
    local ($_) = @_;
    local ($ret_val) = "";
    local ($first) = 1;
    for (split(/\n/)) 
    {
	s/"/\\"/g;
	$ret_val = $ret_val . "\n" . eval qq/"$_"/;

	$first = 0;
    }
    return $ret_val;
}

sub
local_file_field
{
    local ($field, $filename) = @_;;
    local ($contents);
    local ($ret_value);

    print "field = $field, filename = $filename\n";
    

    $contents = read_file ($filename);
    
    $ret_value = match_field ($contents, $field);
    return $ret_value;
}

sub
read_file 
{
    local ($filename) = @_;
    local ($ret_value);
    local ($_);
    
    open (FILE, $filename) || return;
    while (<FILE>)
    {
	$ret_value = $ret_value . $_;
    }
    return $ret_value;
}

sub
get_remote_spec
{
  local ($remote, $user, $password, $remote_file) = @_;
  local ($ftp_port) = 21;
  local ($retry_call) = 1;
  local ($attempts) = 2;
  local ($local_file) = "/tmp/mirrord.version.$$";

  if (&ftp'open ($remote, $ftp_port, $retry_call, $attempts) != 1) 
  {
      die "failed to open ftp connection";
  }
  if (! &ftp'login( $user, $password))
  {
    die "failed to login";
  }
 
   &ftp'type( $text_mode ? 'A' : 'I' );
   if (! &ftp'get( $remote_file, $local_file, 0))
   {  
     die "failed to get file";
   }
  &ftp'quit;
  
  $file = read_file ($local_file);

  return $file;
}

# Match a multi line pattern from a string
# E.g.
# if $string =
# <COMMENT>
# This is
# A comment
# </COMMENT>
# `match_field ($string, "<COMMENT>")'  would return
# This is
# A coment
#
sub
match_field 
{
  local ($_, $begin) = @_;
  local ($end);
  local ($old) = $*;
  local ($value);

  $* = 1;
  $end = "<\/" . substr ($begin, 1, length ($begin) - 1);
  if (/^\s*${begin}\n([\n\s\S]*)\n${end}/)
   {
    if ($1[length ($1) - 1] eq "\r")
    {
	$value = substr ($1, 0, length ($1) - 1);
    }
    else
    {
	$value = $1;
    }
   }

  $* = $old;
  return $value;
}



