/* $Id: utility.c,v 1.2 1995/07/25 20:09:14 dante Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#if defined (HAVE_SYSLOG_H)
#  include <syslog.h>
#endif /* !SYS_SYSLOG */
#include <netdb.h>

#include <floodd.h>
#include <utility.h>
#include <errno.h>

extern int debug;

/* return an inetnet socket address for the given host port pair.
 * If host is null, use the current host.
 */

struct sockaddr_in *
inet_sockaddr (char *host, int port)
{
  struct sockaddr_in *sin;
  struct hostent *hp = NULL;
  char local_host[MAXHOSTNAMELEN + 1];
  unsigned char address[4];

  memset (address, 0, sizeof (address));

  if (isaddress (host))
    {
      unsigned int a, b, c, d;
      sscanf (host, "%d.%d.%d.%d", &a, &b, &c, &d);
      address[0] = a;
      address[1] = b;
      address[2] = c;
      address[3] = d;
    }
  else
    {
      if (host == NULL)               /* default to current host */
	{
	  if (gethostname (local_host, MAXHOSTNAMELEN) == -1)
	    {
	      syslog (LOG_ERR, "gethostname() failed: %m");
	      exit (1);
	    }
	  host = local_host;
	}

      hp = gethostbyname (host);

      if (hp == NULL)
	return (NULL);
    }

  sin = xmalloc (sizeof (struct sockaddr_in));
  memset ((char *) sin, 0, sizeof (struct sockaddr_in));

  if (address[3] != 0)
    {
      /* address should already be in network byte order */
      memcpy ((char *) &sin->sin_addr.s_addr, address, sizeof (address));
      sin->sin_family = AF_INET;
    }
  else
    {
      memcpy ((char *) &(sin->sin_addr), hp->h_addr, hp->h_length);
      sin->sin_family = hp->h_addrtype;
    }

  sin->sin_port = htons (port);

  return (sin);
}

void
send_unknown_reply (SiteID *id)
{
  Message message;
  struct sockaddr_in to;
  int to_len = sizeof (to);

  extern int ping_socket;

  siteid_to_inet_address (id, &to);

  memset (&message, 0, sizeof (message));

  message.type = htonl (TYPE_UNKNOWN);
  message.id.site = whoami->id;
  message.sender = whoami->id;
  sendto (ping_socket, (void *) &message, sizeof (message), 0,
	  (struct sockaddr *) &to, to_len);
}

/* Convert the data to a site identifier */
SiteID *
scan_siteid (char *data, SiteID *id)
{
  struct sockaddr_in *address;
  char host[128];
  int host_pos = 0;
  int data_pos = 0;
  int port;

  
  /* skip leading blanks */
  while (data && data[data_pos] && 
	 data[data_pos] && isspace (data[data_pos]))
    data_pos++;
  
  /* Copy until a space or a ':' 
   * Get the host name
   */
  while (data && data[data_pos] && (host_pos < (sizeof (host) - 1))
	 && (!isspace (data[data_pos]) && data[data_pos] != ':'))
    host[host_pos++] = data[data_pos++];

  host[host_pos] = '\0';
  data_pos++;
  /* Get the port number */
  /* skip leading blanks */
  while (data && data[data_pos] && 
	 data[data_pos] && isspace (data[data_pos]))
    data_pos++;

  port = atoi (&data[data_pos]);
  
  if (port <= 0)
    return (NULL);

  address = inet_sockaddr (host, port);
  if (address == NULL)
    return (NULL);

  if (id == NULL)
    id = xmalloc (sizeof (SiteID));

  id->port.port = address->sin_port;
  memcpy (id->addr.bytes, &address->sin_addr.s_addr,
	 sizeof (address->sin_addr.s_addr));

  xfree (address);
  return (id);
}

struct sockaddr_in *
siteid_to_inet_address (SiteID *id, struct sockaddr_in *address)
{
  if (address == NULL)
    address = xmalloc (sizeof (struct sockaddr_in));
  
  memcpy (&address->sin_addr.s_addr, id->addr.bytes,
	 sizeof (address->sin_addr.s_addr));
  address->sin_port = id->port.port;
  return (address);
}


/* Figure out who I am.
 * If I have a name, use it,
 * Otherwise, See if I can uniquely identify myself by my inet address
 */

SiteInfo *
find_myself (Group *group, char *name)
{
  char hostname[MAXHOSTNAMELEN];
  SiteInfo *result = NULL;
  int i;

  if (name != NULL)
    result = site_by_name (name);
  else
    {
      struct hostent *hp;

      /* Try inet address */
      gethostname (hostname, MAXHOSTNAMELEN);
      hp = gethostbyname (hostname);

      for (i = 0; sites[i] != NULL; i++)
	{
	  if (memcmp (hp->h_addr, &sites[i]->address->sin_addr, hp->h_length) == 0)
	    {
	      if (result != NULL) /* found two */
		return (NULL);
	      result = sites[i];
	    }
	}
    }
  return (result);
}


#define BREAK_CHARACTERS " :\t"

isaddress (char *address)
{
  int dots = 0;
  int last_was_digit = 1;	/* fake it in the beginning */

  if (address == NULL)
    return (0);
  while (*address != '\0')
    {
      if (*address == '.')
	{
	  if (last_was_digit == 0)
	    return (0);
	  last_was_digit = 0;
	  address++;
	  dots++;
	  continue;
	}
      if (!isdigit (*address))
	return (0);
      last_was_digit = 1;
      address++;
    }
  if (dots != 3)
    return (0);

  return (1);
}

/* 
 * Handle address masks.
 */

typedef struct 
{
  unsigned char bytes[4];
} Mask;

Mask *
mask_new (char *string)
{
  Mask *mask;
  struct sockaddr_in *address;

  address = inet_sockaddr (string, 0);

  if (address == NULL)
    {
      syslog (LOG_ERR, "Bad mask `%s'\n", string);
      return (NULL);
    }

  mask = xmalloc (sizeof (Mask));
  memcpy (mask->bytes, (char *)&address->sin_addr.s_addr, sizeof (mask->bytes));
  xfree (address);
  return (mask);
}

void
mask_free (Mask *mask)
{
  xfree (mask);
}

int
mask_compare (Mask *mask, unsigned char *address)
{
  if (mask->bytes[0] != 0)
    {
      if (mask->bytes[0] != address[0])
	return (1);
    }

  if (mask->bytes[1] != 0)
    {
      if (mask->bytes[1] != address[1])
	return (1);
    }

  if (mask->bytes[2] != 0)
    {
      if (mask->bytes[2] != address[2])
	return (1);
    }
  
  if (mask->bytes[3] != 0)
    {
      if (mask->bytes[3] != address[3])
	return (1);
    }

    return (0);
}

int 
mask_equal (Mask *a, Mask *b)
{
  if (a->bytes[0] != b->bytes[0])
    return (-1);
  if (a->bytes[1] != b->bytes[1])
    return (-1);
  if (a->bytes[3] != b->bytes[2])
    return (-1);
  if (a->bytes[3] != b->bytes[3])
    return (-1);
  return (0);
}

char *
skip_word (char *string)
{
  while (*string && !isspace (*string))
    string++;
  return (string);
}


char *
next_line (char *line)
{
  while (*line && *line != '\n')
    line++;
  if (*line)
    line++;
  return (line);
}


char *
next_word (char *string)
{
  /* skip any leading nonspace characters */
  string = skip_word (string);
  
  /* Now skip trailing whitespace (or leading) */
  string = skip_space (string);

  return (string);
}

#if !defined (HAVE_STRDUP)
char *
strdup (char *string)
{
  char *new_string;
  
  new_string = xmalloc (strlen (string) + 1);
  strcpy (new_string, string);

  return (new_string);
}
#endif
