#ifndef _IO_HANDLER_H_

typedef int IOFunction (int fd, void *state);
typedef int IOCleanup (void *state);

typedef struct 
{
  void *state;
  IOFunction *func;
  IOCleanup *cleanup;
} IORequest;

typedef struct 
{
  int fd;
  int please_close;

  Queue *read_requests;
  Queue *write_requests;
  IORequest *read;

  IORequest *write;
  IOCleanup *cleanup;
} IODescriptor;

void
IODescriptor_terminate (IODescriptor *io);

void *
IO_get_reader (int fd);

void
IO_set_reader (int fd, IOFunction *reader);

void *
IO_get_writer (int fd);

void
IO_set_writer (int fd, IOFunction *writer);

void *
IO_read_state (int fd);


#define _IO_HANDLER_H_
#endif /* _IO_HANDLER_H_ */
