/* $Id: group.h,v 1.3 1995/06/02 17:22:23 dante Exp $ */
#ifndef _GROUP_H_
#define _GROUP_H_
#include <list.h>

#define PLEASE_RUN_TOPOLOGY ((Event *) -1)

typedef struct _Group Group;

struct _Group
{
  char *name;
  List *group_sites;
  SiteInfo **sites;		/* A null terminated list of sites */
  SiteInfo *master_site;	/* master site for this group */
  SiteID   **neighbors;		/* A pointer the the neighboring sites array */
  SiteID   **old_neighbors;	/* Old neighbor array */
  List *neighbor_list;		/* A List of neighboring sites */
  List *old_neighbor_list;	/* The last neighbor list */
  int topology_version;		/* Current version of new_topology */
  int old_topology_version;	/* What it sounds like */

  List *allow_list;		/* accepts these sites into group */
  List *deny_list;		/* deny membership to these sites */

  int estimates_period;		/* how often to send estimates */
  int update_period;		/* how often to send topology updates */
  int ping_period;		/* how long between pings (1/10 seconds) */
  int bandwidth_period;		/* how long between BW Estimations */
  int max_size;			/* how large the group may be */
  int join_period;		/* how long between join requests */

  int topology_connectivity;	/* You tell me... */
  char *topology_generator;	/* The command to used to generate topology */
  char *topology;		/* Current group topology in an ascii string */
  Event *join_event;		/* A convenience variable for helping
				 * reschedule a group join event
				 */
  Event *topology_event;

  /* for fast start */
  int ping_current_period;	/* current ping period */
  int ping_count;		/* num of sites pinged for this group */
  int ping_old_sites;		/* the previos # of sites of this group */

  int bw_current_period;	/* current bandwidth period */
  int bw_count;			/* num of sites estimated for this group */
  int bw_old_sites;		/* the previos # of sites of this group */
};

extern int groups_count;
extern Group **groups;

Group *
group_new (char *name);

void
group_add (Group *group);

Group *
group_by_name (char *name);

void
group_site_add (Group *group, SiteInfo *siteinfo);

void
group_topology_print (Group *group, FILE *file);

void
group_topology_update (Group *group, int version, char *topology);


SiteInfo *group_next_site (SiteInfo *site);

#define GROUP_NOTSET (Group *) -1
#define TOPOLOGY_NOTSET -1
#endif /* _GROUP_H_ */
