/* $Id: dynamic_string.h,v 1.1 1995/04/22 21:46:21 dante Exp $ */
/* Useful macros for building dynamdic string*/
#define string_declare(data) \
  char *data = NULL; \
  int  data##_max = 0; \
  int  data##_length = 0

#define string_init(data, length) \
{ \
  data##_max = length; \
  data##_length = 0; \
  data = xmalloc (data##_max); \
  *data = '\0'; \
}

#define string_free(data) \
{ \
   xfree (data); \
   data = NULL; \
   data##_length = 0; \
   data##_max = 0; \
}

#define string_reset(data) \
{ \
   data[0] = '\0'; \
   data##_length = 0; \
}

#define string_append_character(data, character) \
{ \
  if (data##_length + 1 >= data##_max) \
    { \
      data##_max += 16; \
      data = xrealloc (data, data##_max + 1); \
    } \
  data[data##_length] = character; \
  data##_length++; \
  data[data##_length] = '\0'; \
}

#define string_append_string(data, string) \
{ \
  if ((data##_length + strlen(string)) >= data##_max) \
    { \
      data##_max += strlen (string); \
      data = xrealloc (data, data##_max + 1); \
    } \
  strcat (data, string); \
  data##_length += strlen (string); \
}

#define string_append_int(data, value) \
{ \
  char temp[20]; \
  sprintf (temp, "%d", value); \
  string_append_string (data, temp); \
} 

#define string_append_u_long(data, value) \
{ \
  char temp[20]; \
  sprintf (temp, "%lu", value); \
  string_append_string (data, temp); \
} 

#define string_append_float(data, value) \
{ \
  char temp[40]; \
  sprintf (temp, "%d.%d", (int)(value), (int)((value - (int)value) * 100000));\
  string_append_string (data, temp); \
} 
/*
  gconvert (value, sizeof (temp) - 1, 1, temp); \
*/


#define string_append_address(data, address) \
{ \
  char temp[17]; \
  sprintf (temp, "%d.%d.%d.%d", \
	   address[0], \
	   address[1], \
	   address[2], \
	   address[3]); \
  string_append_string (data, temp); \
}

#define string_append_siteid(data, site_id) \
{ \
   string_append_string (data, siteid_to_string (site_id)); \
}

/* Some useful lispy macros */
#define string_append_string_field(data, preamble, field, value, postamble) \
{ \
   char tmp[128]; \
   sprintf (tmp, "%s(%s %s)%s", preamble, field, value, postamble); \
   string_append_string (data, tmp) \
}

#define string_append_int_field(data, preamble, field, value, postamble) \
{ \
   char tmp[128]; \
   sprintf (tmp, "%s(%s %d)%s", preamble, field, value, postamble); \
   string_append_string (data, tmp) \
}

#define string_append_float_field(data, preamble, field, value, postamble) \
{ \
   char tmp[128]; \
   sprintf (tmp, "%s(%s %d.%d)%s", preamble, field, \
	    (int)(value), (int)((value - (int)value) * 100000), \
	    postamble); \
   string_append_string (data, tmp) \
}

#define string_append_count_field(data, preamble, field, v1, v2, postamble) \
{ \
   char tmp[128]; \
   sprintf (tmp,"%s(%s %d blocks %d bytes)%s",preamble,field,v1,v2,postamble); \
   string_append_string (data, tmp) \
}

