/* $Id$ */

typedef 
void *
SetFunction (void *, char *);

typedef 
void *
GenericFunction (char *);

typedef enum { INTEGER, STRING, FLOAT} FieldType;

typedef struct
{
  char *field;
  void (*set) ();
  FieldType type;
} Field;

typedef struct
{
  char *type;
  char *key;			/* A field that uniquely identifies object */
  Field *fields;
  GenericFunction *lookup_object;
  GenericFunction *new_object;
  void **object_list;
  void **object_array;
} ListType;


/* Forward functions definitions */

ListType *listtype_find (char *key);

Field *field_find (char *name, Field *fields);

extern Field local_fields[];
extern Field group_fields[];
extern Field site_fields[];
