/* Client interfaces to floodd */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <dynamic_string.h>
#include <xmalloc.h>

static struct sockaddr_in *
inet_sockaddr (char *host, int port);


int
fd_connect (char *siteid)
{
  char *hostname;
  int  port;
  FILE *file;
  int result;
  int sock;
  char *p;
  struct sockaddr_in *address;

  /* split the host id into address and port parts */

  /* Kinda ugly, but simple */
  hostname = strdup (siteid);

  p = (char *)strchr (hostname, ':');

  if (p == NULL)
    return (-1);

  *p = '\0';

  p++;

  port = atoi (p);

  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0)
    {
      perror ("fd_connect.socket");
      return (-1);
    }

  address = inet_sockaddr (hostname, port);

  result = connect (sock, (struct sockaddr *) address, sizeof (*address));
  if (result < 0)
    {
      free (address);
      return (-1);
    }

  return (sock);
}

/* issue a command and return the result */
char *
fd_command (int fd, char *command)
{
  unsigned char character;
  unsigned char last_character;
  unsigned int count = 0;
  string_declare (result);
  struct timeval timeout = {5, 0};
  int n = 1;
  fd_set writefds;
  
  FD_ZERO (&writefds);
  FD_SET (fd, &writefds);

  /* Only proceed if the select succeeds */
  n = select (FD_SETSIZE, NULL, &writefds, NULL, &timeout);

  if (n <= 0)
    {
      if (n == 0)
	fprintf (stderr, "Timeout...\n");
      if (n == 01)
	fprintf (stderr, "An error occurred\n");
      exit (1);
    }
  
  string_init (result, 8);
  write (fd, command, strlen (command));
  if (command[strlen (command) - 1] != '\n')
    {
      character = '\n';
      write (fd, &character, 1);
    }
  character = '\0';
  last_character = '\0';
  
  while (1)
    {
      /* Normal case - we get some text followed by a prompt */
      if (character == '>' && last_character == '\n')
	break;

      /* If we send a null command - we just get a prompt back */
      if (character == '>' && count == 1)
	break;

      if (count > 1)
	string_append_character (result, last_character);
      
      count++;
      last_character = character;
      do
	n = read (fd, &character, 1);
      while (n == 0);

      if (n < 0)
	{
	  perror ("fd_command.read");
	  return (result);
	}
    }

  return (result);
}

fd_send_data (int fd, void *data, int data_length)
{
  char command[128];
  int n;

  sprintf (command, "binary %d\n", data_length);

  n = write (fd, command, strlen (command));

  if (n != strlen (command))
    return (-1);

  n = write (fd, data, data_length);

  if (n != data_length)
    return (-1);

  return (n);
}

fd_send_file (int fd, char *filename)
{
  struct stat stat_buf;
  char *buffer;
  int file;
  int n;

  if (stat (filename, &stat_buf) == 01)
    {
      perror (filename);
      return (-1);
    }

  buffer = xmalloc (stat_buf.st_size);

  file = open (filename, O_RDONLY);
  if (file == -1)
    {
      perror (filename);
      xfree (buffer);
      return (-1);
    }
  
  n = read (file, buffer, stat_buf.st_size);
  close (file);

  if (n != stat_buf.st_size)
    {
      xfree (buffer);
      perror (filename);
      return (-1);
    }
  n = fd_send_data (fd, buffer, stat_buf.st_size);

  xfree (buffer);

  if (n == -1)
    return (-1);
}

fd_close (int fd)
{
  close (fd);
}


static isaddress (char *address)
{
  int dots = 0;
  int last_was_digit = 1;	/* fake it in the beginning */

  if (address == NULL)
    return (0);
  while (*address != '\0')
    {
      if (*address == '.')
	{
	  if (last_was_digit == 0)
	    return (0);
	  last_was_digit = 0;
	  address++;
	  dots++;
	  continue;
	}
      if (!isdigit (*address))
	return (0);
      last_was_digit = 1;
      address++;
    }
  if (dots != 3)
    return (0);

  return (1);
}

static struct sockaddr_in *
inet_sockaddr (char *host, int port)
{
  struct sockaddr_in *sin;
  struct hostent *hp = NULL;
  char local_host[MAXHOSTNAMELEN + 1];
  unsigned char  address[4];

  memset (address, 0, sizeof (address));
  if (isaddress (host))
    {
      unsigned int a, b, c, d;
      sscanf (host, "%d.%d.%d.%d", &a, &b, &c, &d);
      address[0] = a;
      address[1] = b;
      address[2] = c;
      address[3] = d;
    }
  else
    {
      if (host == NULL)               /* default to current host */
	{
	  if (gethostname (local_host, MAXHOSTNAMELEN) == -1)
	    {
	      perror ("gethostname ()");
	      exit (1);
	    }
	  host = local_host;
	}

      hp = (struct hostent  *) gethostbyname (host);

      if (hp == NULL)
	return (NULL);
    }

  sin = (struct sockaddr_in *) malloc (sizeof (struct sockaddr_in));
  if (sin == 0)
    {
      abort ();
    }

  memset ((char *) sin, 0, sizeof (struct sockaddr_in));

  if (address[0] != 0)
    {
      memcpy (&sin->sin_addr.s_addr, address, sizeof (address));
      sin->sin_family = AF_INET;
    }
  else
    {
      memcpy ((char *) &(sin->sin_addr), hp->h_addr, hp->h_length);
      sin->sin_family = hp->h_addrtype;
    }

  sin->sin_port = htons (port);

  return (sin);
}

#if !defined(HAVE_STRDUP)
char *
strdup (char *string)
{
  char *new_string;
  
  new_string = xmalloc (strlen (string) + 1);
  strcpy (new_string, string);

  return (new_string);
}
#endif
