#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "udunits.h"

extern utUnit unitstruct ;

void
prttime(double timeval, char *timestr) {
    int i, retcode ;
    int year, month, day, hr, min ;
    float sec ;

    if (utCalendar(timeval, &unitstruct, &year, &month, &day, &hr, &min, &sec)) {
        fprintf(stderr, "Error decoding time value. Return code=%d\n",
	            retcode) ;
	exit(99) ;
    }
    sprintf(timestr, "%04d-%02d-%02d %02d:%02d:%02d", year, month, day,
                                                        hr,   min, (int) sec) ;
    return ;
}
