#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define YEARFACTOR 10000000000L
#define MONTHFACTOR  100000000L
#define DAYFACTOR      1000000L
#define HRFACTOR         10000L
#define MINFACTOR          100L

void
oldprttime(double timeval, char *timestr) {
    int i ;
    long year, month, day, hr, min, sec, left ;

    year = (long) (timeval / (double) YEARFACTOR) ;
    left = (long) (timeval - (double) (year * YEARFACTOR)) ;
    month = left / MONTHFACTOR ;
    left = left - (month * MONTHFACTOR) ;
    day = left / DAYFACTOR ;
    left = left - (day * DAYFACTOR) ;
    hr = left / HRFACTOR ;
    left = left - (hr * HRFACTOR) ;
    min = left / MINFACTOR ;
    sec = left - (min * MINFACTOR) ;
    sprintf(timestr, "%04d-%02d-%02d %02d:%02d:%02d", year, month, day,
                                                        hr,   min, sec) ;
    return ;
}
