Date:         Thu, 02 Dec 1993 14:11:35 EST
From:         "Brian T. Shelden" <shelden@spoke.law.cornell.edu>
To:           sanders@BSDI.COM
Subject:      ismap via server redirection
Reply-To:     bts1@cornell.edu

 
Tony--

	The http://www.novell.com/ bookshelves have given
Tom and Peter ideas.  Hence, I was charged with getting ISMAP
to work under plexus.

	While using your spacewalk example as a template, I
came upon a problem.  Try adding a relative URL to
http://www.bsdi.com/server/walk/pack.html.  (I.e., <img src=
walk.gif>)  What I found is that since clients think that 
they're in the url http://www/decode-walk?x,y, they'll try
to get http://www/decode-walk/walk.gif, when you really want
http://www/server/walk/walk.gif.

	The obvious solution (also used by NCSA's httpd, I
believe) is to use server redirection.  So I did.  Check it
out on http://spoke.law.cornell.edu/ismap.html.

	I also didn't like how you'd have to restart plexus
to add another ismapped image.  So I changed the semantics
a little.  http://machine/ismapped/maphandle is the maphandle.
Now, all you have to do is change the map.conf file, and 
viola, new ismapped images.  No server restart is necessary.
The mapping of "ismapped" -> &do_decode can obviously be changed
to anything you like in local.conf.

	Code follows.  Comments, suggestions, etc welcome, on
either philosophy or implementation.

--Brian Shelden
bts1@cornell.edu
Unix Systems Coordinator
Cornell Law School

---------- /usr/local/www/server/util/decode-shelden.pl ----------

# decode.pl -- image selection decoder
#
# decode.pl,v 2.8 1993/08/31 18:18:14 sanders Exp
#
# Chris McRae <mcrae@ckm.ucsf.edu>, May 1993
# bitmasks added by Tony Sanders <sanders@bsdi.com>, June 1993
# server redirection added by Brian Shelden <bts1@cornell.edu>, December 1993
# runtime maphandles added by Brian Shelden <bts1@cornell.edu>, December 1993
# unknown maphandle errors added by Brian Shelden <bts1@cornell.edu>, December 1993
#
# This is the support code for decoding images.
#
# FYI about bitmasks:
#   For large images using masks you'll want to scale the mask by some factor
#   depending on how accurate the results must be.  It would be better to
#   have a ppm style mask with each "color" being a different object.  If
#   you write this let me know.  Currently you need a mask for each object.
#   The code doesn't currently support this.
#	map_handle pixmask pixmap_file color1 URL1 [menu desc]
#	map_handle pixmask pixmap_file color2 URL2 [menu desc]
#
# &do_decode -- decides what to do (rectangle decoding is built-in)
# &region -- front end to &loadmask and &pixel that caches bitmasks
# &loadmask -- reads the image file into memory
# &pixel -- test if a pixel is set, image must already be loaded by &loadmask
# &rnd -- internal routine for &loadmask for rounding up to nearest byte
#
# XXX: executable URLs
# XXX: scaled bitmasks
#

# Example config lines:
# $map{'decode'} = '&do_decode($path, $query)';


sub do_decode {
    local($path, $query) = @_;
    local($_, @lines, @menu) = (defined($query) && $query);
    local($X, $Y) = split(',', $_);			# unpack $query: x,y
    local($map_config_file) = $plexus{'decode-config'};
    local($title) = "Object menu for image: $map_handle";
    local($map_handle);

    $map_handle = $path;
    if ($map_handle =~ m#^(.*)/(.*)$#) {
	# XXX: && $map{$x} =~ /^&do_decode/ && $1 =~ $x
	$map_handle = $2;
    }

&main'debug("$path -> handle == $map_handle");
    MAP_OPEN: {
	# extract lines from MAP for this object ($map_handle)
	@lines = ();
	&open(MAP, $map_config_file) || die "$map_config_file: $!";
	while (<MAP>) { /^\s*$map_handle\b/ && push(@lines, $_); }
	close(MAP);

	# map_handle default URL
	# map_handle title default_title_for_automenu
	# map_handle config-file map_config_file
	# map_handle bitmask bitmask_file width height URL [menu desc]
	# map_handle rect x y width height URL [menu desc]
	foreach (@lines) {
	    split(" ");					# into @_

	    if ($_[1] =~ /default/i) {
		return &redirect($_[2]) unless defined($query);
	    } elsif ($_[1] =~ /title/i) {
		shift @_; shift @_; $title = join(" ", @_);
	    } elsif ($_[1] =~ /config-file/i) {
		# redirect to another file
		&error('internal_error', "too many lines for $map_handle in $map_config_file")
		    unless $#lines == 0;		# only one allowed
		$map_config_file = $_[2];
		redo MAP_OPEN;
	    } elsif ($_[1] =~ /bitmask/i) {
		# decode by bitmask
		local($bitmask, $w, $h, $URL) = @_[2..5];
		unless (defined($query)) {
		    splice(@_,0,6,());			# delete 0..6
		    push(@menu, join(" ", ($URL, @_)));	# rest is menu text
		    next;
		}
		# XXX: Need to embed width and height in the mask file
		&region($bitmask, $w, $h, $X, $Y) && return &redirect($URL);
	    } elsif ($_[1] =~ /rect/i) {
		# decode by rectangle
		local($x, $y, $w, $h, $URL) = @_[2..6];
		unless (defined($query)) {
		    splice(@_,0,7,());			# delete 0..7
		    push(@menu, join(" ", ($URL, @_)));	# rest is menu text
		    next;
		}
		if (($x < $X) && (($x+$w) > $X) &&
		        ($y < $Y) && (($y+$h) > $Y)) {
		    return &redirect($URL);
		}
	    }
	}
    }
    if (@menu) {
	# No $query -- this menu will only contain
	# the elements in the last config file read.
	&MIME_header('ok', 'text/html');
	print "<HEAD>\n<TITLE>$title</TITLE>\n</HEAD>\n";
	print "<BODY>\nYou can select one of:\n<UL>\n";
	foreach (@menu) {
	    split(" ", $_, 2);
	    print "<LI> <A HREF=\"$_[0]\">$_[1]</A>\n";
	}
	print "</UL>\n</BODY>\n";
    }
    else {
	&main'error('not_found', "There is no map coresponding to handle ``$map_handle''");
    }
}

sub rnd { local($value, $incr) = @_; ($value + ($incr-1)) & ~($incr-1); }

sub loadmask {
    local(*image) = @_;
    local($bits);	# because perl can't sysread into $image{'bits'}
    $image{'scanlen'} = &rnd($image{'width'}, 8);	# whole bytes
    open(BITS, $image{'filename'}) || die "$image{'filename'}: $!";
    sysread(BITS, $bits, $image{'scanlen'} * $image{'height'} / 8);
    close(BITS);
    $image{'bits'} = $bits;
}

sub pixel {
    local(*image, $x, $y) = @_;
    local($offset) = int((($y * $image{'scanlen'}) + $x)/8);
    local($byte) = unpack("c", substr($image{'bits'}, $offset, 4)) & 0xff;
    return (($byte & (1<<($x%8))) != 0);
}

$imgatom = "img000";				# generate unique names
%imgatom = ();

sub region {
    local($file, $width, $height, $x, $y) = @_;
    local($a);

    # cached?
    defined($a = $imgatom{$file}) || do {
	$a = $imgatom{$file} = $imgatom++;		# string increment
	eval "
	    \$$a{'filename'} = \$file;
	    \$$a{'width'} = \$width;
	    \$$a{'height'} = \$height;
	    &main'loadmask(*$a);";
	die $@ if $@;
    };
    return eval "&main'pixel(*$a, \$x, \$y)";
}


#------------------------------------------------------------------------------
# Server redirect to the $url given
#------------------------------------------------------------------------------
sub redirect {
	local($url) = @_;
	local($msg);

	# Some browsers won't be redirected to a relative URL.
	# What lossage:
	if ($url !~ m#^\w+\://#) {
		local($slash) = '/';
		$slash = '' if $url =~ m#^/#;
		# relative URL.  Hack http:// on the front:
		substr($url, $[, 0) = "http://$hostname" . $slash;
	}
	# Spec says:
	$main'out_headers{'URL'} = $url;
	# Mosaic does:
	$main'out_headers{'Location'} = $url;
	$msg =<<"EOM";
If you are seeing this message, the server is trying to
redirect you do the url <a href="$url">$url</a>, and
your client doesn't support server redirection.<p>

Click on the url above to go there.
EOM
	return &main'error('moved', $msg);
}
	
1;
