/* pbmtomask.c - read a portable bitmap and produce a 'walk' mask
   a small hack based on the pbmtoxbm.c file by Axel.belinfante@cs.utwente.nl
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include "pbm.h"

void main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifp;
    bit *bitrow;
    register bit *bP;
    int rows, cols, format, padright, row;
    register int col;
    char name[100], *cp;
    register int bitsperitem;
    register int item;
    static char hexchar[] = "0123456789abcdef";

    pbm_init( &argc, argv );

    if ( argc > 2 )
	pm_usage( "[pbmfile]" );

    if ( argc == 2 )
	{
	ifp = pm_openr( argv[1] );
	strcpy( name, argv[1] );
	if ( strcmp( name, "-" ) == 0 )
	    strcpy( name, "noname" );

	if ( ( cp = index( name, '.' ) ) != 0 )
	    *cp = '\0';
	}
    else
	{
	ifp = stdin;
	strcpy( name, "noname" );
	}

    pbm_readpbminit( ifp, &cols, &rows, &format );
    bitrow = pbm_allocrow( cols );
    
    /* Compute padding to round cols up to the nearest multiple of 8. */
    padright = ( ( cols + 7 ) / 8 ) * 8 - cols;

    bitsperitem = 0;
    item = 0;

#define PUTITEM \
    { \
    putchar(item); \
    bitsperitem = 0; \
    item = 0; \
    }

#define PUTBIT(b) \
    { \
    if ( bitsperitem == 8 ) \
	PUTITEM; \
    if ( (b) == PBM_BLACK ) \
	item += 1 << bitsperitem; \
    bitsperitem++; \
    }

    for ( row = 0; row < rows; row++ )
	{
	pbm_readpbmrow( ifp, bitrow, cols, format );
        for ( col = 0, bP = bitrow; col < cols; col++, bP++ )
	    PUTBIT(*bP);
	for ( col = 0; col < padright; col++ )
	    PUTBIT(0);
        }

    if ( ifp != stdin )
	fclose( ifp );

    if ( bitsperitem > 0 )
	PUTITEM;

    exit( 0 );
    }
