# mime.pl -- handle MIME headers
#
# $Id: mime.pl,v 2.2 1993/06/23 00:33:03 sanders Exp $
#
# by Tony Sanders <sanders@bsdi.com>, April 1993
#

#
# Any additional headers are expected in %out_headers
#
sub MIME_header {
    local($status, $content) = @_;
    alarm($http_timeout);
    return 0 unless $version;       # if $version !~ m/$htrq_version/i;
    $status = 'internal_error' unless defined($code{$status});
    printf("%s %s\n", $http_version, $code{$status});
    printf("Date: %s\n", &fmt_date(time));
    printf("Server: %s\n", $server_version);
    printf("MIME-version: 1.0\n");
    &unparse_headers(*out_headers);
    printf("Content-type: $content\n\n");
    return 1;
}

sub fmt_date {
    local($time) = @_;
    local(@DoW) = ('Sunday','Monday','Tuesday','Wednesday',
                   'Thursday','Friday','Saturday');
    local(@MoY) = ('Jan','Feb','Mar','Apr','May','Jun',
		   'Jul','Aug','Sep','Oct','Nov','Dec');
    local($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
        gmtime($time);
    sprintf("%s, %02d-%s-%02d %02d:%02d:%02d GMT",
        $DoW[$wday], $mday, $MoY[$mon], $year, $hour, $min, $sec);
}

sub parse_headers {
    local(*headers) = @_;
    local($_, $field);
    while ($_ = <NS>) {
	s/[ \t\r\n]*$//;
	last if /^$/;		# leave the body of the message for whomever
	# &debug("header: $_"); # DEBUG: XXX: FIXME
        if (/^[ \t]/) {
	    # continuation line
            last unless $field;
            s/^[ \t]*/ /;
            $headers{$field} .= $_;
        } else {
	    $field = &add_header(*headers, $_);
	}
    }
}

sub add_header {
    local(*headers, $_) = @_;
    local($field, $data) = split(/\s*:\s*/, $_, 2);
    $field =~ y/A-Z/a-z/; substr($field,0,1) =~ y/a-z/A-Z/;
    $headers{$field} .= "\377" if defined $headers{$field};
    $headers{$field} .= $data;
    return $field;
}

#
# Spit headers back out from internal format
#
sub unparse_headers {
    local(*headers, @list, $i) = @_;
    local($,);
    foreach $i (keys %headers) {
        @list = grep($_ .= "\n", split("\377", $headers{$i}));
        $, = "$i: "; print "",@list;
    }
}

1;
