/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/acc.c
    Version 2.22
    
    Copyright (C) 1995  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.
*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "gn.h"

static int	isabove();

/*
 * chkaccess( ip, log) checks whether the client's IP address is in the 
 * allowed list (either the access file for each directory if accesstype=DIRCHK
 * or the access file in the root directory if accesstype=ROOTDIR).  If allowed
 * it returns TRUE, if not FALSE.  If accesstype=FREE, it just returns TRUE.
 * If log is TRUE and access is denied a note of the failure is placed in
 * the log file.
 */

int
chkaccess( ip, log)
Item	*ip;
int	log;
{
	static char	lastvalid[PATHLEN] = { '\0'};
	char	*accdir;


	FILE	*fp;
	int	len,
		notflag,
		match,
		found = FALSE;
	char	*cp,
		*rptr,
		buf1[SMALLLEN],
		linebuf[PATHLEN],
		accdirbuf[PATHLEN],
		accessfile[PATHLEN];

	struct stat stat_buf;


	accdir = ip->accdir;
	switch ( accesstype) {
		case FREE:
			return TRUE;
		case ROOTCHK:
			if ( *lastvalid )  /* Already checked this */
				return TRUE;
			sprintf( accessfile, "%s/%s", accdir, afname);
			break;
		case DIRCHK:

		/* Look for access file in current directory, and if
		   not found work our way up to rootdir looking for it */

			mystrncpy( accdirbuf, accdir, PATHLEN);
			rptr = accdirbuf + strlen( rootdir);
			cp = rptr + 1;
			while ( cp > rptr ) {
				if ( isabove( accdirbuf, lastvalid))
					return TRUE;
				  /* We can tell the outcome from the last 
					access check */

				sprintf( accessfile, "%s/%s",
					accdirbuf, afname);

				if ( stat( accessfile, &stat_buf) == 0 ) {
					found = TRUE;
					break;
				}
				cp = strrchr( accdirbuf, '/');
				*cp = '\0';
			}
			if ( found == FALSE ) {	/* No access file so allow */
				strcpy( lastvalid, accdir);
				return TRUE;
			}
			break;
		default:
			senderr2( "Unknown access error", "");
	}

	if ((fp = fopen( accessfile, "r")) == (FILE *)NULL ) {
		senderr2( "Can't open file", accessfile);
		exit( 2);
	}

	while ( fgets( linebuf, PATHLEN, fp)) {
		chop(linebuf);
		cp = linebuf;

		if ( notflag = ( *cp == '!'))
			cp++;
		len = strlen( cp);

		if ( (len == 0) || (*cp == '#') )
			continue;
		strlower( cp);

		match = wild_match( remotehost, cp);
		if ( cp[ strlen(cp) -1] != '.') {
			strcat( cp, ".");
			len++;
		}
		mystrncpy( buf1, remaddr, SMALLLEN - 1);
		strcat( buf1, ".");

		if ( match || (strncmp( cp, buf1, len) == 0)) {
			if ( notflag)
				break;
			else {
				fclose( fp);
				strcpy( lastvalid, accdir);
				return TRUE;
			}
		}
	}
	fclose( fp);
	if ( log)
		writelog( "", "Access denied request was", ip->selector);
	return FALSE;
}

static int
isabove( shorter, longer)
char	*shorter,
	*longer;
{
	while ( *shorter && *longer ) {
		if ( *shorter++ != *longer++)
			return FALSE;
	}
	if ( *shorter)
		return FALSE;  /* It wasn't shorter */

	if ( (!*longer) || ( *longer == '/'))
		return TRUE;
	else
		return FALSE;
}
