#!/usr/local/bin/perl

# This perl script does two fairly different things.  If is invoked
# with the environmental variable PATH_INFO set to "ismap" then it
# prints out the X and Y coordinates which it obtains from the
# environment variable QUERY_STRING.  Otherwise it assumes it has been
# invoked to handle an HTML form (via the GET or POST method) and
# processes and prints out the values and variables set in that form.

print "Content-type: text/plain\n\n";

$GN_ARG = $ENV{PATH_INFO};  # Get the argument from the URL
$GN_QUERY = $ENV{QUERY_STRING};
$GN_QUERY =~ s/\+/ /g;		# Change +'s to spaces

if ( $GN_ARG =~ /ismap/) {          # Print the X,Y coords from QUERY_STRING
	($x, $y) = split( /,/, $GN_QUERY);
	print( "Here are the X and Y coordinates of the point\n");
	print( "on which you clicked: ");
	print( "X = ", $x, ", Y = ", $y, "\n");
	exit( 0);
}




if ( $ENV{REQUEST_METHOD} eq "GET") {

# It's the GET method, so assume it is a form with QUERY_STRING a string
# of the form"param1=value1&param2=value2&param3=value3..." and create an
# associative array with keys the params.


	@QUERY_LIST = split( /&/, $GN_QUERY);

	foreach $item (@QUERY_LIST) {
        	($param, $value) = split( /=/, $item);
		 $QUERY_ARRAY{$param} .= $value;
		 $QUERY_ARRAY{$param} .= " ";
	}

	# Now print it all out.

print <<EOF;
        Here are the parameters and their values which were
        sent by your form:

EOF

	foreach $param ( sort( keys(%QUERY_ARRAY))) {
		print( $param, " = ", $QUERY_ARRAY{$param}, "\n");
	}
}


if ( $ENV{REQUEST_METHOD} eq "POST") {
	
# It's the POST method, so print content length and coded input from
# STDIN.  Then decode it and print again.

	$len = $ENV{CONTENT_LENGTH};
	print "Posted input content-length = $len \n";
	$postinput = <STDIN>;
	print "Undecoded posted input:\n$postinput\n\n";
	$postinput =~ s/&/\n/g;
	$postinput =~ s/\+/ /g;
	$postinput =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;
	print "Decoded posted input:\n$postinput\n";
}
