/*		Chunk handling:	Flexible arrays
**		===============================
**
*/

#include "HTUtils.h"
#include "HTChunk.h"
#include <stdio.h>
/*	Create a chunk with a certain allocation unit
**	--------------
*/
#ifdef __STDC__
PUBLIC HTChunk * HTChunkCreate(int grow)
#else
PUBLIC HTChunk * HTChunkCreate()
    int grow;
#endif
{
    HTChunk * ch = (HTChunk *) malloc(sizeof(HTChunk));
    if (!ch) return 0;
    ch->data = 0;
    ch->growby = grow;
    ch->size = 0;
    ch->allocated = 0;
    return ch;
}


/*	Clear a chunk of all data
**	--------------------------
*/
#ifdef __STDC__
PUBLIC void HTChunkClear(HTChunk * ch)
#else
PUBLIC void HTChunkClear(ch)
    HTChunk *ch;
#endif
{
    if (ch->data) {
	free(ch->data);
	ch->data = 0;
    }
    ch->size = 0;
    ch->allocated = 0;
}


/*	Append a character
**	------------------
*/
#ifdef __STDC__
PUBLIC void HTChunkPutc(HTChunk * ch, char c)
#else
PUBLIC void HTChunkPutc(ch, c)
    HTChunk *ch;
    char c;
#endif
{
    if (ch->size >= ch->allocated) {
	ch->allocated = ch->allocated + ch->growby;
        ch->data = ch->data ? (char *)realloc(ch->data, ch->allocated)
			    : (char *)malloc(ch->allocated);
	if (!ch->data) {
	    fprintf(stderr, "Chunk memory allocation error!\n");
	    exit(-1);
	}
    }
    ch->data[ch->size++] = c;
}


/*	Ensure a certain size
**	---------------------
*/
#ifdef __STDC__
PUBLIC void HTChunkEnsure(HTChunk * ch, int needed)
#else
PUBLIC void HTChunkEnsure(ch, needed)
    HTChunk *ch;
    int needed;
#endif
{
    if (needed <= ch->allocated) return;
    ch->allocated = needed-1 - ((needed-1) % ch->growby)
    			     + ch->growby; /* Round up */
    ch->data = ch->data ? (char *)realloc(ch->data, ch->allocated)
			: (char *)malloc(ch->allocated);
    if (!ch->data) {
	fprintf(stderr, "Chunk memory allocation error!\n");
	exit(-1);
    }
}


/*	Terminate a chunk
**	-----------------
*/
#ifdef __STDC__
PUBLIC void HTChunkTerminate(HTChunk * ch)
#else
PUBLIC void HTChunkTermiante(ch)
    HTChunk *ch;
#endif
{
    HTChunkPutc(ch, (char)0);
}


/*	Append a string
**	---------------
*/
#ifdef __STDC__
PUBLIC void HTChunkPuts(HTChunk * ch, const char *s)
#else
PUBLIC void HTChunkPuts(ch, s)
    HTChunk *ch;
    char *s;
#endif
{
    CONST char * p;
    for (p=s; *p; p++)
        HTChunkPutc(ch, *p);
}
