/* util header file - by Reinier Post */

#include <stdio.h>
#include <stdlib.h>

#ifndef tolower
#define tolower(C) (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))
#endif

#define my_getenv(var) (getenv(var) ? getenv(var) : "")

extern int match (char *pattern, char *s);
/* 1 if the pattern matches somewhere in s, 0 if it doesn't */
/* a pattern is a string in which '*' stands for 1 or more arbitrary chars */
/* the wildcard cannot be escaped; there is no way to match a literal * */

extern int stringtobool(char *value);
extern int stringtoint(char *value);
extern int stringtotime(char *value);
/* all return -1 for uninterpretable string, else the (nonnegative) value */
/* except stringtoint which returns -1 on "0" and on "-1", too */

extern void strsubfirst(int start,char *dest, char *src);
extern void skip_whitespace(char **s);  /* by RP */
extern void cfg_getword(char *word, char *line);
extern void skipspace(char *line);  /* by RP */
extern void getword(char *word, char *line, char stop);
extern void getword2(char *word, char *line, char stop);  /* by RP */
extern int getline(char *s, int n, int f, unsigned int timeout);
extern int cfg_getline(char *s, int n, FILE *f);
extern void unescape_url(char *url);
extern void escape_url(char *url);
extern void escape_url_with_slashes(char *url);
int is_url(char *u);
extern void plustospace(char *str);
extern int ind(char *s, char c);
extern int rind(char *s, char c);
extern void send_fd(FILE *f, FILE *fd);

extern int readn(int fd, char *ptr, int nbytes);
