/*
 * rel2abs.c: test program for rel2abs routine in html.c
 *
 * Reinier Post (reinpost@win.tue.nl)
 */

/*
 * $Log: rel2abs.c,v $
 * Revision 0.15  1994/05/18  08:00:37  reinpost
 * *** empty log message ***
 *
 * Revision 0.13  1994/05/03  19:32:46  reinpost
 * *** empty log message ***
 *
 * Revision 0.13  1994/05/03  19:32:46  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:47:26  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:47:26  reinpost
 * *** empty log message ***
 *
 * Revision 0.9  1994/03/02  21:25:52  reinpost
 * *** empty log message ***
 *
 * Revision 0.9  1994/03/02  21:25:52  reinpost
 * *** empty log message ***
 *
 * Revision 0.6  1994/02/17  21:26:20  reinpost
 * *** empty log message ***
 *
 * Revision 0.6  1994/02/17  21:26:20  reinpost
 * *** empty log message ***
 *
 * Revision 0.5  1994/02/17  10:27:09  reinpost
 * untested since last release
 *
 * Revision 0.3  1994/02/01  19:59:25  reinpost
 * incorporated the extra arg of rel_to_abs
 * this code is unsupported really
 *
 * Revision 0.3  1994/02/01  19:59:25  reinpost
 * incorporated the extra arg of rel_to_abs
 * this code is unsupported really
 *
 *
 * Revision 0.1  1994/01/20  12:19:43  reinpost
 * separate program - no longer used and quite dirty in the way it does I/O
 *
 */

static char rcsid[] =
  "$Id: rel2abs.c,v 0.15 1994/05/18 08:00:37 reinpost Exp reinpost $";

#include <fcntl.h>
#include <stdio.h>
#include <errno.h>

#include "system.h"

#include "constants.h"
#include "html.h"	/* my own HTML parsing & translation stuff */

int main(int argc, char *argv[])
{
  char in_buf [BIG_BUF_LEN];
  char scratch [BIG_BUF_LEN];
  char out_buf [BIGGER_BUF_LEN];
  char *cache_prefix = argv[1];
  char *abs_prefix = argv[2];
  int nb = 1; /* to enter the loop, nothing else */
  int rc;
  int ctr = 0;
  char *in; char *out;

  if (argc != 3)
  {
    fprintf(stderr,"Usage: %s cache-prefix absolute-prefix\n",argv[0]);
    return 1;
  }

  in = in_buf;
  while (nb)
  {
    ctr = 0;
    while (ctr++ < 25 && !(nb = read(0, in, BIG_BUF_LEN + (in_buf - in) - 1)));

    if (nb)
    {
    /*fprintf(stderr,"successfully read %d bytes\n",nb);*/
    in[nb] = '\0';
    in = in_buf; out = out_buf;

    if ((rc = rel_to_abs(&out,&in,abs_prefix,cache_prefix,BIGGER_BUF_LEN,0)))
    {
      /* something went wrong */
      if (rc == 2)
      {
        /* fprintf(stderr,"buffer overflow, memory damage\n"); */
	write (1,"error: buffer overflow",strlen("error: buffer overflow"));
	return 2;
      }
      else
      /* not the whole input was converted */
      {
	/* fprintf(stderr,"rc = %d, src moved only %d of %d\n",rc,in-in_buf,strlen(in_buf)); */
	strcpy(scratch,in);  /* in case it doesn't work char by char */
	/* fprintf(stderr,"rest: %s\n",scratch); */
	strcpy(in_buf,scratch);
        in = in_buf + strlen(in_buf);
	/* forget some of the output, too */
	*out = '\0';
      }
    }
    else
    {
      in = in_buf;
    }
    out = out_buf;
    if (write(1,out_buf,strlen(out_buf)) == -1) perror("rel2abs: write failed");
    /* fprintf(stderr,"successfully written %d bytes\n",strlen(out_buf)"); */
    /* fprintf(stderr,"the last 10 read are %s, the last 10 written are %s\n",&in_buf[strlen(in_buf)-10],&out_buf[strlen(out_buf)-10]); */
    }
  }
  return 0;
}
