/*			Lynx Document Reference List Support	      LYList.c
**			====================================
**
**	Author:	FM	Foteos Macrides (macrides@sci.wfbr.edu)
**
*/

#include "HTUtils.h"
#include "tcp.h"
#include "LYUtils.h"
#include "LYList.h"
#include "GridText.h"
#include "LYSignal.h"
#include "LYGlobalDefs.h"

#ifdef DIRED_SUPPORT
#include "LYUpload.h"
#include "LYLocal.h"
#endif /* DIRED_SUPPORT */

#include "LYexit.h"
#include "LYLeaks.h"
 
#define FREE(x) if (x) {free(x); x = NULL;}

/* 	showlist - F.Macrides (macrides@sci.wfeb.edu)
**	--------
**  	Create a temporary text/html file with a list of links to
**	HyperText References in the current document.
**
** On entry
**	titles		Set:	if we want titles where available
**			Clear:  we only get addresses.
*/

PUBLIC void showlist ARGS2(char **, newfile, BOOL, titles)
{
    int cnt;
    int refs;
    static char *tmpfile=NULL;
    static char list_filename[256];
    FILE *fp0;
    char *cp = NULL;

    refs = HText_sourceAnchors(HTMainText);
    if (refs <= 0) {
	_statusline("There are no references from this document.");
	sleep(MessageSecs);
	return;
    }

    if(tmpfile == NULL) {
	tmpfile = (char *) malloc(128);
	if (!tmpfile)
	    outofmem(__FILE__, "showlist");
	tempname(tmpfile,NEW_FILE);
    }
#ifdef VMS
    else {
	remove(tmpfile);  /* put VMS code to remove duplicates here */
    }
#endif /* VMS */

    if((fp0 = fopen(tmpfile,"w")) == NULL) {
	perror("Trying to open list file\n");
	exit(-1);
    }

    /* make the file a URL now */
#ifdef VMS
    sprintf(list_filename,"file://localhost/%s",tmpfile);
#else
    sprintf(list_filename,"file://localhost%s",tmpfile);
#endif /* VMS */
    StrAllocCopy(*newfile, list_filename);
    LYforce_HTML_mode=TRUE; /* force this file to be HTML */
    LYforce_no_cache=TRUE; /* force this file to be new */

    fprintf(fp0,"<head>\n<title>%s</title>\n</head>\n<body>\n",
						LIST_PAGE_TITLE);

    fprintf(fp0,"<h1>You have reached the List Page</h1>\n");
    fprintf(fp0,"<h2>%s Version %s</h2>\n", LYNX_NAME, LYNX_VERSION);

    fprintf(fp0, "  References in this document:<p>\n");
    fprintf(fp0, "<%s compact>\n", (keypad_mode == LINKS_ARE_NUMBERED) ?
    				   "ul" : "ol");
    for (cnt=1; cnt<=refs; cnt++) {
	HTAnchor *dest = HTAnchor_followMainLink((HTAnchor *)
						 HText_childNumber(cnt));
	HTParentAnchor * parent = HTAnchor_parent(dest);
	char * address =  HTAnchor_address(dest);
	CONST char * title = titles ? HTAnchor_title(parent) : NULL;

	if (title)
	    cp=strchr(address, '#');
        fprintf(fp0, "<li><a href=\"%s\">%s%s%s%s</a>\n", address,
			((HTAnchor*)parent!=dest) && title ? "in " : "",
			(char *)(title ? title : address),
			(title && cp) ? " - " : "",
                        (title && cp) ? (cp+1) : "");

	FREE(address);
    }

    fprintf(fp0,"\n</%s>\n</body>\n", (keypad_mode == LINKS_ARE_NUMBERED) ?
    				      "ul" : "ol");

    fclose(fp0);
    return;
}      


/* 	printlist - F.Macrides (macrides@sci.wfeb.edu)
**	---------
**  	Print a text/plain list of HyperText References
**	in the current document.
**
** On entry
**	titles		Set:	if we want titles where available
**			Clear:  we only get addresses.
*/

PUBLIC void printlist ARGS2(FILE *, fp, BOOL, titles)
{
#ifdef VMS
    extern BOOLEAN HadVMSInterrupt;
#endif /* VMS */
    int cnt;
    int refs;
    refs = HText_sourceAnchors(HTMainText);
    if (refs <= 0) {
        return;
    } else {
	fprintf(fp, "\n%s\n\n", "References");
	for (cnt=1; cnt<=refs; cnt++) {
	    HTAnchor *dest =
		HTAnchor_followMainLink((HTAnchor *)
					HText_childNumber(cnt));
	    HTParentAnchor * parent = HTAnchor_parent(dest);
	    char * address =  HTAnchor_address(dest);
	    CONST char * title = titles ? HTAnchor_title(parent) : NULL;
	    fprintf(fp, "%4d. %s%s\n", cnt,
		    ((HTAnchor*)parent!=dest) && title ? "in " : "",
		    (char *)(title ? title : address));
	    FREE(address);
#ifdef VMS
	    if (HadVMSInterrupt)
	        break;
#endif /* VMS */
	}
    }
    return;
}      
