
/* Copyright (c) CNIDR (see ../COPYRIGHT) */

/* byte_order:
 *  This file contains some useful routines to handle the differences between
 *  big and little endian machines. The macros may look a little unwieldy, but
 *  any modern optimiser will take care of things quite nicely. 
 *
 * $Log: byte_order.h,v $
 * Revision 1.1  1993/02/16  15:05:35  freewais
 * Initial revision
 *
 * Revision 1.1  92/03/15  08:49:03  jonathan
 * Initial revision
 * 
 */

#include "../config.h"


/* ASSIGN_HELPER:
    This macro turns a pointer to long into a pointer to a {1,2,3} byte value
*/

#ifdef BIG_ENDIAN
#define ASSIGN_HELPER(var,size) (FOUR_BYTE*)((ONE_BYTE*) &var+(sizeof(FOUR_BYTE)-size))
#else
#define ASSIGN_HELPER(var,size)  (FOUR_BYTE *)&var
#endif 

/*
  ASSIGN(var,size,src,unit,offset): 
     var : variable to store into
     size: how big is value?
     src : source address
     unit,offset: 
      These paramaters are used to help optimise the macro when used with 
      structured data. unit should be the size of one record, and offset should
      be the offset of this item within that record. These paramaters are *not*
      used to calculate the source address - they are used purely to let the
      compiler take advantage of possibly aligned data. 

      ASSIGN_NATIVE uses native byte ordering
      ASSIGN_CANON  uses canonical (big_endian) byte ordering
*/

#if defined(NATIVE_ORDER) || defined(BIG_ENDIAN)
#define ASSIGN ASSIGN_NATIVE
#else
#define ASSIGN ASSIGN_CANON
#endif

#define ASSIGN_NATIVE(var,size,src,unit,offset) {\
  FOUR_BYTE *dst;\
    dst = ASSIGN_HELPER(var,size);\
  switch(size) \
    {\
    case 1:\
      var = 0;\
      *(unsigned ONE_BYTE*)dst= *(unsigned ONE_BYTE*)(src);\
      break;\
    case 2:\
      if (!(unit % TWO_BYTE_ALIGN) && !(offset % TWO_BYTE_ALIGN)) {\
        var = 0;\
	*(unsigned TWO_BYTE *)dst = *(unsigned TWO_BYTE *)(src);\
      } else {\
	var =0;\
	*(unsigned ONE_BYTE *)dst = *(unsigned ONE_BYTE *)(src);\
	*((unsigned ONE_BYTE *)dst+1) = *(unsigned ONE_BYTE*)(src+1);\
      }\
      break;\
    case 3:\
      var = 0;\
      *(unsigned ONE_BYTE *)dst = *(unsigned ONE_BYTE *)(src);\
      *((unsigned ONE_BYTE *)dst+1) = *(unsigned ONE_BYTE*)(src+1);\
      *((unsigned ONE_BYTE *)dst+2) = *(unsigned ONE_BYTE*)(src+2);\
      break;\
    case 4:\
      if (!(unit % FOUR_BYTE_ALIGN) && !(offset % FOUR_BYTE_ALIGN)) { \
	*dst = *(unsigned FOUR_BYTE *)(src);\
      } else {\
	*(unsigned ONE_BYTE *)dst = *(unsigned ONE_BYTE *)(src);\
	*((unsigned ONE_BYTE *)dst+1) = *(unsigned ONE_BYTE*)(src+1);\
	*((unsigned ONE_BYTE *)dst+2) = *(unsigned ONE_BYTE*)(src+2);\
	*((unsigned ONE_BYTE *)dst+3) = *(unsigned ONE_BYTE*)(src+3);\
      }\
      break;\
    }\
}

#define ASSIGN_CANON(var,size,src,unit,offset) {\
  FOUR_BYTE *dst;\
    dst = ASSIGN_HELPER(var,size);\
  switch(size) \
    {\
    case 1:\
      var = 0;\
      *(unsigned ONE_BYTE*)dst= *(unsigned ONE_BYTE*)(src);\
      break;\
    case 2:\
      var =0;\
      *(unsigned ONE_BYTE *)dst = *(unsigned ONE_BYTE *)(src+1);\
      *((unsigned ONE_BYTE *)dst+1) = *(unsigned ONE_BYTE*)(src);\
      break;\
    case 3:\
      var = 0;\
      *(unsigned ONE_BYTE *)dst = *(unsigned ONE_BYTE *)(src+2);\
      *((unsigned ONE_BYTE *)dst+1) = *(unsigned ONE_BYTE*)(src+1);\
      *((unsigned ONE_BYTE *)dst+2) = *(unsigned ONE_BYTE*)(src);\
      break;\
    case 4:\
      *(unsigned ONE_BYTE *)dst = *(unsigned ONE_BYTE *)(src+3);\
      *((unsigned ONE_BYTE *)dst+1) = *(unsigned ONE_BYTE*)(src+2);\
      *((unsigned ONE_BYTE *)dst+2) = *(unsigned ONE_BYTE*)(src+1);\
      *((unsigned ONE_BYTE *)dst+3) = *(unsigned ONE_BYTE*)(src);\
      break;\
    }\
}
