#ifndef __TCAPTURE_H
//	Avoid include redundancy
#define __TCAPTURE_H

//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Include File:	tcapture.h
//	Purpose:	Provides a class that will insert text into a dumb
//			terminal from stdout and stderr c streams.  This
//			class works in conjunction with the source file
//			capstdio.c
//	Remarks/Portability/Dependencies/Restrictions:
//		Requires the capstdio.c file.
//	Revision History:
//		01-08-94	created

//	Constant defines
#define Uses_TWindow
#define Uses_TTerminal
#define Uses_TRect
#define Uses_TEvent

//	Required includes
#include<tv.h>
#include<iostream.h>

//	Class/Function declarations
class TCapture : public TWindow	{
	TTerminal *TT;
public:
	ostream_withassign DumbStream;
	TCapture(TRect TR, const char *cp_title, unsigned short int
		usi_bufsize);
	void handleEvent(TEvent& TE);
};

extern "C" void cap_stdout(const char *);
extern "C" void cap_stderr(const char *);

//	Global variable declarations

//	Macros
//	Capture C++ streams also, This could be messy.
#include"globals.h"

#define cout { ::TC->show(); ::TC->makeFirst(); } (::TC->DumbStream)
#define cerr { ::TC->show(); ::TC->makeFirst(); } (::TC->DumbStream)
#define clog { ::TC->show(); ::TC->makeFirst(); } (::TC->DumbStream)
#define doslynxmessage(message) { cout << "doslynx:  " << message << '\n'; }

#endif // __TCAPTURE_H
