//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TCapture
//	Include File:	tcapture.h
//	Purpose:	Captures c streams stdout and sterr to a window.
//	Remarks/Portability/Dependencies/Restrictions:
//		Works in conjuction with the c source file capstdio.c and
//		two global variables capstdout and capstderr in globals.c
//	Revision History:
//		01-08-94	created
//		02-09-94	Split all members into seperate files.
#define Uses_otstream
#include"tcapture.h"

TCapture::TCapture(TRect TR, const char *cp_title, unsigned short int
	usi_bufsize) :
	TWindowInit(TCapture::initFrame),
	TWindow(TR, cp_title, 0)	{
//	Purpose:	Constructor of the TCapture object.
//	Arguments:	TR		The rectangle to occupy.
//			cp_title	The title of the window.
//			usi_bufsize	The size of the buffer for the dumb
//					terminal.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-08-94	created

	//	Set out palette to that of a message window.
	palette = wpCyanWindow;

	//	Get the size of the window.
	//	Create the terminal.
	TR = getExtent();
	TR.grow(-1, -1);

	TT = new TTerminal(TR, NULL, standardScrollBar(sbVertical |
		sbHandleKeyboard), usi_bufsize);
	insert(TT);

	otstream ot(TT);
	DumbStream = ot;
}
