#ifndef _WHOISD_H_
#define _WHOISD_H_

#define	 MAX_FILENAME	   128

#define	 MAX_CONSTRAINT_LEN	 64
#define	 MAX_CONSTRAINT_DESC	 64
#define	 MAX_CONSTRAINT_VALUES	 64
#define	 MAX_CONSTRAINT_SCOPE	 16

#define	DEF_MAXHITS	100

typedef enum{
   CON_HOLD = 0,
   CON_MAXHITS,
   CON_LOGICAL,
   CON_MATCH,
   CON_LAST		  /* Must be the last one in the list */
} con_num_t;

typedef enum{
   C_SGLOBAL,
   C_SLOCAL
} scope_t;

typedef struct{
   con_num_t  con_num;		       /* Index number for constraint */
   char	con_name[MAX_CONSTRAINT_LEN];  /* Constraint string (name)    */
   char con_desc[MAX_CONSTRAINT_DESC]; /* Consttraint description     */
   char con_values[MAX_CONSTRAINT_VALUES];
   scope_t con_scope;
} constraint_set_t;


extern int get_input proto_(());
extern int do_search proto_((WItem *,WItem *));
extern int do_system proto_((WItem *, WItem *));
extern int wais_interface proto_((char *,int,WItem *,char *,char *,int,char *));
extern int list_templates proto_((WItem *, char *));
extern int breakout_template proto_((WItem *,char *));


#endif
