/*
 * Copyright 1993, Bunyip Information Systems. This file is part of the
 * Bunyip WHOIS++ distribution and may be freely distributed as long as
 * this notice remains intact. This file may not be used in any product for
 * commercial gain.
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <strings.h>
#include <string.h>
#include <memory.h>
#include <search.h>
#include "whois.h"
#include "whoisd.h"
#include "templates.h"

/* global verbose variable */

int verbose = 0;

/* global "hold connection"  variable */

int hold = 0;

/* global version */

char *version  = "Bunyip V1.0 Alpha";

/* global maxhits */

int maxhits = DEF_MAXHITS;

/* global logicals */

Val logical = WAND;

int main(argc, argv)
   int argc;
   char *argv[];

{
   extern int getopt();

   extern int opterr;	   /* See getopt(3) */
   extern char *optarg;

   char **cmdline_ptr;	   /* Internal "options" variables */
   int cmdline_args;
   char config_file[MAX_FILENAME];
   char log_file[MAX_FILENAME];
   FILE *logfp = (FILE *) NULL;


   int option;

   /* Turn getopt(3) complaints off */

   opterr = 0;


   /* ignore argv[0] */

   cmdline_ptr = argv + 1;
   cmdline_args = argc - 1;

   config_file[0] = '\0';
   log_file[0] = '\0';

   /* process command line options */

   while((option = (int) getopt(argc, argv, "C:vd:D:l:")) != EOF){

      switch(option){

	 /* configuration file name */

	 case 'C':
	    strcpy(config_file, optarg);
	    cmdline_ptr += 2;
	    cmdline_args -= 2;
	    break;

	 case 'D':
	    wSetDebug(atoi(optarg));
	    cmdline_ptr += 2;
	    cmdline_args -= 2;
	    break;

	 /* working directory */

	 case 'd':
	    chdir(optarg);
	    cmdline_ptr += 2;
	    cmdline_args -= 2;
	    break;

	 /* Log file */
	 case 'l':
	    strcpy(log_file, optarg);
	    cmdline_ptr += 2;
	    cmdline_args -= 2;
	    break;

	 /* verbose mode */

	 case 'v':
	    verbose = 1;
	    cmdline_ptr++;
	    cmdline_args--;
	    break;

	 default:
	    fprintf(stderr, "Usage: %s [ -h <hash file> ] [ -v ]\n", argv[0]);
	    exit(1);
	    break;
      }
   }


   if(config_file[0] == '\0')
      strcpy(config_file, DEF_TEMPLATE_CONFIG);
      

   /* read the configuration file */

   if(read_template_config(config_file) != 0)
      exit(1);

   wPutLine(stdout, wErrorReply(WINFO_WELCOME, "%s", version));

   /* open the log file */

   if(log_file[0]){

      if((logfp = fopen(log_file, "a")) == (FILE *) NULL){
	 wPutLine(stdout, wErrorReply(WERR_LOGFILE, "%s", log_file));
	 exit(1);
      }
   }

   
   /* perform the search */

   get_input(logfp);

   exit(0);
   return(0);

}

