/*
 * Copyright 1993, Bunyip Information Systems. This file is part of the
 * Bunyip WHOIS++ distribution and may be freely distributed as long as
 * this notice remains intact. The contents of this file may not be used in
 * any product for commercial gain.
 */

#include <stdio.h>
#include <whois.h>
#include "templates.h"

/* list_templates:

   list the templates that the server knows about */

int list_templates(reply, rhs)
   WItem *reply;
   char *rhs;

{
   extern template_str *template_head;	  /* global template list */

   template_str *t_current;
   WItem *curr_item;

   /* go through each template type and list their contents */

   for(t_current = template_head; t_current -> t_name[0] != '\0'; t_current++){

      /* If we've found a definition for the template then list it */

      if((curr_item = t_current -> t_def))
	 curr_item = curr_item -> next;
      else
	 continue;

      /* If a particular template has been specified */

      if(rhs && *rhs)
        if(strcasecmp(rhs, t_current -> t_name) != 0)
         continue;

      wAppendTerm(reply, R_FULL_FMT, "TEMPLATE", t_current -> t_name);

      while(curr_item != (WItem *) NULL){

	 wAppendTerm(reply, NO_VAL, curr_item -> lhs, curr_item -> rhs);

	 curr_item = curr_item -> next;
      }

   }

   return(0);
}

		     
	 
