/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.82
   Wed Apr 24 1991

   jonathan@Think.COM

*/

#define XWAISQ_C
#define MAIN
#include "xwais.h"

#define offset(field) XtOffset(struct _app_resources*, field)
static XtResource resources[] = {
   {"questionDirectory", "QuestionDirectory", XtRString, sizeof(char *),
         offset(questionDirectory), XtRString, "~/wais-questions/"},
   {"userSourceDirectory", "UserSourceDirectory", XtRString, sizeof(char *),
         offset(userSourceDirectory), XtRString, "~/wais-sources/"},
   {"commonSourceDirectory", "CommonSourceDirectory", XtRString, sizeof(char *),
         offset(commonSourceDirectory), XtRString, ""},
   {"documentDirectory", "DocumentDirectory", XtRString, sizeof(char *),
         offset(documentDirectory), XtRString, "~/wais-documents/"},
   {"helpFile", "HelpFile", XtRString, sizeof(char *),
         offset(helpFile), XtRString, "./XwaisHELP"},
   {"removeSeekerCodes", "RemoveSeekerCodes", XtRString, sizeof(char *),
      offset(removeSeekerCodes), XtRString, "On"},
   {"rescanInterval", "RescanInterval", XtRString, sizeof(char *),
      offset(rescanInterval), XtRString, "1"},
   {"seedWords", "SeedWords", XtRString, sizeof(char *),
      offset(seedWords), XtRString, ""},
   {"initialSource", "InitialSource", XtRString, sizeof(char *),
      offset(initialSource), XtRString, ""},
   {"questionName", "QuestionName", XtRString, sizeof(char *),
      offset(questionName), XtRString, ""},
   {"filters", "Filters", XtRString, sizeof(char *),
      offset(filters), XtRString, ""},
   {"maximumResults", "MaximumResults", XtRInt, sizeof(int),
      offset(maximumResults), XtRImmediate, (caddr_t) 40},
   {"doSearch", "DoSearch", XtRBoolean, sizeof(Boolean),
      offset(doSearch), XtRBoolean, False},
   {"defaultsInstalled", "DefaultsInstalled",  XtRBoolean, sizeof(Boolean),
      offset(defaultsInstalled), XtRBoolean, False},
   {"showKeys", "ShowKeys",  XtRBoolean, sizeof(Boolean),
      offset(showKeys), XtRBoolean, False}
};
#undef offset

XtActionsRec xwaisActionsTable[] = {
  /* special for return only */
  {(String)"waissearch", (XtActionProc)DoSearch},
  {(String)"save", (XtActionProc)DoSave},
  {(String)"tsave", (XtActionProc)DoTSave},
  NULL
  };

ExitCommand()
{
  exit(-1);
}

PopExit(parent, message)
Widget parent;
char *message;
{
  Widget shell, frame, labelwid, stringlabelwid;
  WidgetClass wclass;
  static String namestring;
  Arg		args[5];
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;

  shell = XtCreatePopupShell("exitpopup", applicationShellWidgetClass,
			     parent, NULL, ZERO);
  frame = XtCreateManagedWidget("exitpopupform", formWidgetClass,
				shell, NULL, ZERO);

  labelwid = MakeLabel(frame, "exitlabel", message, NULL, NULL);

  MakeCommandButton(frame, "Ok", ExitCommand, labelwid, NULL, NULL);

  n = 0;
  XtSetArg(args[n], XtNx, 100); n++;
  XtSetArg(args[n], XtNy, 100); n++;
  XtSetArg(args[n], XtNtitle, "XWAIS Question Error"); n++;
  XtSetValues(shell, args, n);
 
  XtPopup(shell, XtGrabExclusive);
}



/* this will take as its argument the name of a question file,
   and will do all the right things with it.
*/


char *log_file_name = NULL;
FILE *logfile = NULL;

void
main(argc, argv)
     int argc;
     char *argv[];
{
  long count;
  Widget frame, labelwid, stringlabelwid, button;
  WidgetClass wclass;
  static String
    name = "";
  Arg arglist[10];
  Cardinal num_args;
  static String items[] = {NULL};
  int n;
  float shown;
  Question question;
  char msg[STRINGSIZE];

  the_Source = (Source) s_malloc(sizeof(_Source));

  NumSources = 0;

  allText = NULL;

  double_click = FALSE;

  freopen("/dev/null", "a", stderr);

  top = XtInitialize( "xwais", "Xwais", NULL, 0, &argc, argv);
  
  XtAddActions(xwaisActionsTable, XtNumber(xwaisActionsTable));

  XtGetApplicationResources(top, &app_resources, resources,
			    XtNumber(resources), NULL, 0);

  if (app_resources.defaultsInstalled == False) {
    PopExit(top, "X resources not properly installed");
    XtMainLoop();
  }

  if(app_resources.documentDirectory[0] == '~') {
    char *home, *dir, *getenv();
    
    if((home = getenv("HOME")) != NULL) {
      if((dir = s_malloc(strlen(home) +
		       strlen(app_resources.documentDirectory) +
		       2)) == NULL) {
	fprintf(stderr, "Ran out of space trying to create directory name.\n");
	exit(-1);
      }
      strcpy(dir, home);
      strcat(dir, &app_resources.documentDirectory[1]);
      app_resources.documentDirectory=dir;
    }
  }

  if(app_resources.userSourceDirectory[0] == '~') {
    char *home, *dir, *getenv();
    
    if((home = getenv("HOME")) != NULL) {
      if((dir = s_malloc(strlen(home) +
		       strlen(app_resources.userSourceDirectory) +
		       2)) == NULL) {
	fprintf(stderr, "Ran out of space trying to create directory name.\n");
	exit(-1);
      }
      strcpy(dir, home);
      strcat(dir, &app_resources.userSourceDirectory[1]);
      app_resources.userSourceDirectory=dir;
    }
  }

  if(app_resources.questionDirectory[0] == '~') {
    char *home, *dir, *getenv();
    
    if((home = getenv("HOME")) != NULL) {
      if((dir = s_malloc(strlen(home) +
		       strlen(app_resources.questionDirectory) +
		       2)) == NULL) {
	fprintf(stderr, "Ran out of space trying to create directory name.\n");
	exit(-1);
      }
      strcpy(dir, home);
      strcat(dir, &app_resources.questionDirectory[1]);
      app_resources.questionDirectory=dir;
    }
  }
  /* let's see if it exists, if not, try to create it */
  {
    DIR *dirp;
    char *makedir;

    if((dirp = opendir(app_resources.questionDirectory)) == NULL) {
      if((makedir = s_malloc(strlen(app_resources.questionDirectory) + 12))
	 == NULL) {
	fprintf(stderr, "Ran out of space trying to create directory name.\n");
	exit(-1);
      }
      strcpy(makedir, "/bin/mkdir ");
      strcat(makedir, app_resources.questionDirectory);
      if(makedir[strlen(makedir)-1] == '/') makedir[strlen(makedir)-1] = 0;
      if(system(makedir) != 0)
	fprintf(stderr, "Error creating directory: %s\n",
		app_resources.questionDirectory);
    }
    else
      closedir(dirp);

    if((dirp = opendir(app_resources.userSourceDirectory)) == NULL) {
      if((makedir = s_malloc(strlen(app_resources.userSourceDirectory) + 12))
	 == NULL) {
	fprintf(stderr, "Ran out of space trying to create directory name.\n");
	exit(-1);
      }
      strcpy(makedir, "/bin/mkdir ");
      strcat(makedir, app_resources.userSourceDirectory);
      if(makedir[strlen(makedir)-1] == '/') makedir[strlen(makedir)-1] = 0;
      if(system(makedir) != 0)
	fprintf(stderr, "Error creating directory: %s\n",
		app_resources.userSourceDirectory);
    }
    else
      closedir(dirp);

    if((dirp = opendir(app_resources.documentDirectory)) == NULL) {
      if((makedir = s_malloc(strlen(app_resources.documentDirectory) + 12))
	 == NULL) {
	fprintf(stderr, "Ran out of space trying to create directory name.\n");
	exit(-1);
      }
      strcpy(makedir, "/bin/mkdir ");
      strcat(makedir, app_resources.documentDirectory);
      if(makedir[strlen(makedir)-1] == '/') makedir[strlen(makedir)-1] = 0;
      if(system(makedir) != 0)
	fprintf(stderr, "Error creating directory: %s\n",
		app_resources.documentDirectory);
    }
    else
      closedir(dirp);
  }
  
  {
    char qfilename[256];
    FILE *fp;

    if (argc == 1) /* we have no quesiton specified.  Let's just make a new one */
      {
	the_Question = (Question)s_malloc(sizeof(_Question));
	if(app_resources.questionName[0] != 0)
	  strcpy(the_Question->name, app_resources.questionName);
	else
	  strcpy(the_Question->name, "New Question");
      }
    else if (argc == 2)
      {
	sprintf(qfilename, "%s%s", app_resources.questionDirectory, argv[1]);

	if((fp = fopen(qfilename, "r")) == NULL) {
	  fprintf(stderr, "Can't open question %s\n", qfilename);
	  exit(-1);
	}

	the_Question = (Question)s_malloc(sizeof(_Question));
	strcpy(the_Question->name, argv[1]);

	ReadQuestion(the_Question, fp);
	fclose(fp);
      }
    else
      {
	fprintf(stderr, "usage: %s [Question_file_name]", argv[0]);
	exit(0);
      }
  }

  if (app_resources.seedWords[0] != 0
      && the_Question->keywords[0] == 0)
    strcpy(the_Question->keywords, app_resources.seedWords);

  if (app_resources.initialSource[0] != 0
      && the_Question->Sources == NULL) {
    the_Question->Sources = makeSourceList((SourceID)s_malloc(sizeof(_SourceID)),
				       NULL);
    the_Question->Sources->thisSource->filename = s_strdup(app_resources.initialSource);
  }    

  CurDpy = XtDisplay(top);

  MakeQuestionForm(the_Question);

  sourcepopup = (Widget) MakeSourcePopup(top);

  messwidget = the_Question->window->StatusWindow;

  ReadSourceDirectory(app_resources.userSourceDirectory, TRUE);
  if(app_resources.commonSourceDirectory[0] != 0)
    ReadSourceDirectory(app_resources.commonSourceDirectory, TRUE);

  SortSources();

  Source_items = buildSItemList(Sources);

  /* and away we go! */

  question = the_Question;

  sprintf(msg, "X WAIS Question: %s",  question->name);

  num_args = 0;
  XtSetArg(arglist[num_args], XtNtitle, msg); num_args++;
  XtSetArg(arglist[num_args], XtNiconName, msg); num_args++;
  XtSetValues(top, arglist, num_args);

  question->modified = TRUE;

  sourcewindow = (ScrollList)MakeSourceFrame(top);

  XtRealizeWidget(top);

  /* do all  the necessary stuff */

  question->Source_Items =
    buildSourceItemList(question->Sources, FALSE);

  RebuildListWidget(question->window->Sources, question->Source_Items);
  RebuildListWidget(sourcewindow, Source_items);

  question->numsources = charlistlength(question->Source_Items);

  question->Relevant_Items =
    buildDocumentItemList(question->RelevantDocuments, FALSE);

  RebuildListWidget(question->window->RelevantDocuments,
		    question->Relevant_Items);

  question->numdocs = charlistlength(question->Relevant_Items);

  question->Result_Items =
    buildDocumentItemList(question->ResultDocuments, TRUE);

  RebuildListWidget(question->window->ResultDocuments,
		    question->Result_Items);

  question->numresdocs = charlistlength(question->Result_Items);

  if(app_resources.doSearch != False) DoSearch(NULL, NULL, NULL);

  XtMainLoop();
}

void
Feep()
{
  if (CurDpy != NULL)
    XBell(CurDpy, 0);
}

