/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.8
   Fri Feb  1 1991

   jonathan@Think.COM

*/

#ifndef _H_QUESTION
#define _H_QUESTION

#include "../ir/ui.h"

#define MAX_MESSAGE_LEN BUFSZ

#define MAX_QUERY_SIZE 1000
#define QUESTION_FILE_VERSION 1

#define CHARS_PER_PAGE 2000

typedef struct QuestionWindow {
  Widget shell;
  Widget keywordwid;
  ScrollList Sources;
  ScrollList RelevantDocuments;
  ScrollList ResultDocuments;
  Widget StatusWindow;
  Widget Textwindow;
  char *textbuffer;
} _QuestionWindow, *QuestionWindow;

typedef struct question{
  char *type;
  char name[STRINGSIZE];
  char keywords[STRINGSIZE];
  short version;
  short view;
  int numsources;
  SourceList Sources;
  char **Source_Items;
  int CurrentSource;
  int numdocs;
  DocList RelevantDocuments;
  char **Relevant_Items;
  int CurrentRelDoc;
  int numresdocs;
  DocList ResultDocuments;
  char **Result_Items;
  int CurrentResDoc;
#ifndef NOTX
  QuestionWindow window;
#endif
  char request_message[MAX_MESSAGE_LEN]; /* arbitrary message limit */
  char response_message[MAX_MESSAGE_LEN]; /* arbitrary message limit */
  SearchResponseAPDU  *query_response;
  SearchResponseAPDU  *retrieval_response;
  WAISSearchResponse  *query_info;
  Boolean modified;
} _Question, *Question;

/* function definitions */

Question findQuestionWindow();
QuestionWindow MakeQuestionWindow();
void DeleteQuestionWindow();
char **buildQuestionItemList();
DocList build_response_list();
void SearchWais();
Boolean ViewWaisDocument();
boolean init_for_source();
DocumentID getNextorPrevDoc();

#endif
